/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.phase4.marshaller.Ebms3NamespaceHandler;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.EXMLSerializeXMLDeclaration;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class AS4XMLHelper {
    public static final XMLWriterSettings XWS = XMLWriterSettings.createForCanonicalization();

    private AS4XMLHelper() {
    }

    @Nonnull
    private static String _serializePh(@Nonnull Node node) {
        return XMLWriter.getNodeAsString((Node)node, (IXMLWriterSettings)XWS);
    }

    @Nonnull
    private static String _serializeRT(@Nonnull Node node) {
        String string;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        try {
            transformer.transform(new DOMSource(node), new StreamResult((Writer)nonBlockingStringWriter));
            string = nonBlockingStringWriter.getAsString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    nonBlockingStringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TransformerException transformerException) {
                throw new IllegalStateException("Failed to serialize XML", transformerException);
            }
        }
        nonBlockingStringWriter.close();
        return string;
    }

    @Nonnull
    public static String serializeXML(@Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return AS4XMLHelper._serializeRT(node);
    }

    static {
        XWS.setNamespaceContext((NamespaceContext)((Object)Ebms3NamespaceHandler.getInstance()));
        XWS.setIndent(EXMLSerializeIndent.NONE);
        XWS.setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.EMIT_NO_STANDALONE);
    }
}

