/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.phive.api.EValidationBaseType;
import com.helger.phive.api.IValidationType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EValidationType implements IValidationType
{
    XML("xml", EValidationBaseType.XML, "XML Syntax"),
    XSD("xsd", EValidationBaseType.XSD, "XML Schema"),
    PARTIAL_XSD("partial-xsd", EValidationBaseType.XSD, "Partial XML Schema"),
    SCHEMATRON_PURE("schematron-pure", EValidationBaseType.SCHEMATRON, "Schematron (pure; XPath-only)"),
    SCHEMATRON_SCH("schematron-sch", EValidationBaseType.SCHEMATRON, "Schematron (SCH; ISO XSLT2)"),
    SCHEMATRON_SCHXSLT("schematron-schxslt-xslt2", EValidationBaseType.SCHEMATRON, "Schematron (SchXslt XSLT2)"),
    SCHEMATRON_XSLT("schematron-xslt", EValidationBaseType.SCHEMATRON, "Schematron (ISO XSLT2)"),
    SCHEMATRON_OIOUBL("schematron-xslt-oioubl", EValidationBaseType.SCHEMATRON, "Schematron (OIOUBL XSLT)");

    private final String m_sID;
    private final EValidationBaseType m_eBaseType;
    private final String m_sName;

    private EValidationType(@Nonnull @Nonempty String string2, EValidationBaseType eValidationBaseType, String string3) {
        this.m_sID = string2;
        this.m_eBaseType = eValidationBaseType;
        this.m_sName = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public EValidationBaseType getBaseType() {
        return this.m_eBaseType;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    public boolean isStopValidationOnError() {
        return this.m_eBaseType.isXML() || this.m_eBaseType.isXSD();
    }

    @Override
    public boolean isContextRequired() {
        return this == PARTIAL_XSD;
    }

    @Nullable
    public static EValidationType getFromIDOrNull(@Nullable String string) {
        return (EValidationType)EnumHelper.getFromIDOrNull(EValidationType.class, (Object)string);
    }
}

