/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phive.api.EValidationBaseType;
import com.helger.phive.api.IValidationType;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ValidationType
implements IValidationType {
    private final String m_sID;
    private final EValidationBaseType m_eBaseType;
    private final String m_sName;
    private final boolean m_bStopValidationOnError;
    private final boolean m_bContextRequired;

    public ValidationType(@Nonnull @Nonempty String string, @Nonnull EValidationBaseType eValidationBaseType, @Nonnull @Nonempty String string2, boolean bl, boolean bl2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        ValueEnforcer.notNull((Object)((Object)eValidationBaseType), (String)"BaseType");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Name");
        this.m_sID = string;
        this.m_eBaseType = eValidationBaseType;
        this.m_sName = string2;
        this.m_bStopValidationOnError = bl;
        this.m_bContextRequired = bl2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public EValidationBaseType getBaseType() {
        return this.m_eBaseType;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    public boolean isStopValidationOnError() {
        return this.m_bStopValidationOnError;
    }

    @Override
    public boolean isContextRequired() {
        return this.m_bContextRequired;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationType validationType = (ValidationType)object;
        return this.m_sID.equals(validationType.m_sID) && this.m_eBaseType.equals((Object)validationType.m_eBaseType) && this.m_sName.equals(validationType.m_sName) && this.m_bStopValidationOnError == validationType.m_bStopValidationOnError && this.m_bContextRequired == validationType.m_bContextRequired;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Enum)this.m_eBaseType).append((Object)this.m_sName).append(this.m_bStopValidationOnError).append(this.m_bContextRequired).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("BaseType", (Enum)this.m_eBaseType).append("Name", (Object)this.m_sName).append("StopValidationOnError", this.m_bStopValidationOnError).append("ContextRequired", this.m_bContextRequired).getToString();
    }
}

