/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.executorset;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSetMutable;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.api.source.IValidationSource;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ValidationExecutorSetAlias<SOURCETYPE extends IValidationSource>
implements IValidationExecutorSetMutable<SOURCETYPE> {
    private final DVRCoordinate m_aVESID;
    private final String m_sDisplayName;
    private final IValidationExecutorSetMutable<SOURCETYPE> m_aVES;

    public ValidationExecutorSetAlias(@Nonnull DVRCoordinate dVRCoordinate, @Nonnull @Nonempty String string, @Nonnull IValidationExecutorSetMutable<SOURCETYPE> iValidationExecutorSetMutable) {
        ValueEnforcer.notNull((Object)dVRCoordinate, (String)"ID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
        ValueEnforcer.notNull(iValidationExecutorSetMutable, (String)"Status");
        this.m_aVESID = dVRCoordinate;
        this.m_sDisplayName = string;
        this.m_aVES = iValidationExecutorSetMutable;
    }

    @Nonnull
    public final DVRCoordinate getID() {
        return this.m_aVESID;
    }

    @Nonnull
    @Nonempty
    public final String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public final Iterator<IValidationExecutor<SOURCETYPE>> iterator() {
        return this.m_aVES.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<IValidationExecutor<SOURCETYPE>> executors() {
        return this.m_aVES.executors();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IValidationExecutor<SOURCETYPE>> getAllExecutors() {
        return this.m_aVES.getAllExecutors();
    }

    @Override
    @Nonnull
    public final IValidationExecutorSetStatus getStatus() {
        return this.m_aVES.getStatus();
    }

    @Override
    @Nonnull
    public ValidationExecutorSetAlias<SOURCETYPE> addExecutor(@Nonnull IValidationExecutor<SOURCETYPE> iValidationExecutor) {
        this.m_aVES.addExecutor(iValidationExecutor);
        return this;
    }

    @Override
    public void setValidationExecutorDoCache(boolean bl) {
        this.m_aVES.setValidationExecutorDoCache(bl);
    }

    @Override
    @Nonnull
    public EChange removeAllExecutors() {
        return this.m_aVES.removeAllExecutors();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationExecutorSetAlias validationExecutorSetAlias = (ValidationExecutorSetAlias)object;
        return this.m_aVESID.equals((Object)validationExecutorSetAlias.m_aVESID) && this.m_sDisplayName.equals(validationExecutorSetAlias.m_sDisplayName) && this.m_aVES.equals(validationExecutorSetAlias.m_aVES);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aVESID).append((Object)this.m_sDisplayName).append(this.m_aVES).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_aVESID).append("DisplayName", (Object)this.m_sDisplayName).append("VES", this.m_aVES).getToString();
    }
}

