/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.executorset;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsNavigableMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.diver.api.version.DVRPseudoVersionRegistry;
import com.helger.diver.api.version.DVRVersion;
import com.helger.diver.api.version.IDVRPseudoVersion;
import com.helger.phive.api.config.PhivePseudoVersionRegistrarSPIImpl;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.source.IValidationSource;
import java.time.OffsetDateTime;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ValidationExecutorSetRegistry<SOURCETYPE extends IValidationSource>
implements IValidationExecutorSetRegistry<SOURCETYPE> {
    public static final boolean DEFAULT_RESOLVE_PSEUDO_VERSIONS = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationExecutorSetRegistry.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<DVRCoordinate, IValidationExecutorSet<SOURCETYPE>> m_aMap = new CommonsHashMap();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bResolvePseudoVersions = true;

    @Override
    public final boolean isResolvePseudoVersions() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bResolvePseudoVersions);
    }

    @Override
    public final void setResolvePseudoVersions(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bResolvePseudoVersions = bl;
        });
    }

    @Nonnull
    @MustBeLocked(value=ELockType.DEPENDS)
    protected final ICommonsMap<DVRCoordinate, IValidationExecutorSet<SOURCETYPE>> internalMap() {
        return this.m_aMap;
    }

    @Override
    public void registerValidationExecutorSet(@Nonnull IValidationExecutorSet<SOURCETYPE> iValidationExecutorSet) {
        ValueEnforcer.notNull(iValidationExecutorSet, (String)"VES");
        DVRCoordinate dVRCoordinate = (DVRCoordinate)iValidationExecutorSet.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)dVRCoordinate)) {
                throw new IllegalStateException("Another validation executor set with the ID '" + dVRCoordinate.getAsSingleID() + "' is already registered!");
            }
            this.m_aMap.put((Object)dVRCoordinate, (Object)iValidationExecutorSet);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered validation executor set '" + dVRCoordinate.getAsSingleID() + "' of type " + iValidationExecutorSet.getClass().getName() + " with " + iValidationExecutorSet.getCount() + " elements");
        }
    }

    @Override
    @Nonnull
    public EChange unregisterValidationExecutorSet(@Nullable DVRCoordinate dVRCoordinate) {
        if (dVRCoordinate == null) {
            return EChange.UNCHANGED;
        }
        EChange eChange = (EChange)this.m_aRWLock.writeLockedGet(() -> this.m_aMap.removeObject((Object)dVRCoordinate));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((eChange.isChanged() ? "Successfully unregistered" : "Failed to unregister") + " validation executor set '" + dVRCoordinate.getAsSingleID() + "'");
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IValidationExecutorSet<SOURCETYPE>> getAll() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfValues());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IValidationExecutorSet<SOURCETYPE>> findAll(@Nonnull Predicate<? super IValidationExecutorSet<SOURCETYPE>> predicate) {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfValues(predicate));
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> findFirst(@Nonnull Predicate<? super IValidationExecutorSet<SOURCETYPE>> predicate) {
        return (IValidationExecutorSet)this.m_aRWLock.readLockedGet(() -> (IValidationExecutorSet)this.m_aMap.findFirstValue(entry -> predicate.test((Object)entry.getValue())));
    }

    @Nullable
    private ICommonsNavigableMap<DVRCoordinate, IValidationExecutorSet<SOURCETYPE>> _getAllMatchingVES(@Nullable String string, @Nullable String string2, @Nonnull Predicate<DVRVersion> predicate, @Nullable Comparator<DVRCoordinate> comparator) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        if (StringHelper.hasNoText((String)string2)) {
            return null;
        }
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap(comparator);
        this.m_aRWLock.readLocked(() -> this.lambda$_getAllMatchingVES$7(string, string2, predicate, (ICommonsNavigableMap)commonsTreeMap));
        return commonsTreeMap;
    }

    @Nullable
    private IValidationExecutorSet<SOURCETYPE> _getOldestVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set, boolean bl) {
        ICommonsNavigableMap<DVRCoordinate, IValidationExecutorSet<SOURCETYPE>> iCommonsNavigableMap = this._getAllMatchingVES(string, string2, DVRVersion.getStaticVersionAcceptor(set, (boolean)bl), Comparator.naturalOrder());
        if (iCommonsNavigableMap != null && iCommonsNavigableMap.isNotEmpty()) {
            IValidationExecutorSet iValidationExecutorSet = (IValidationExecutorSet)iCommonsNavigableMap.getFirstValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved oldest version of '" + string + ":" + string2 + "' to '" + ((DVRCoordinate)iValidationExecutorSet.getID()).getVersionString() + "'");
            }
            return iValidationExecutorSet;
        }
        return null;
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getOldestVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set) {
        return this._getOldestVersion(string, string2, set, true);
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getOldestReleaseVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set) {
        return this._getOldestVersion(string, string2, set, false);
    }

    @Nullable
    private IValidationExecutorSet<SOURCETYPE> _getLatestVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set, boolean bl) {
        ICommonsNavigableMap<DVRCoordinate, IValidationExecutorSet<SOURCETYPE>> iCommonsNavigableMap = this._getAllMatchingVES(string, string2, DVRVersion.getStaticVersionAcceptor(set, (boolean)bl), Comparator.reverseOrder());
        if (iCommonsNavigableMap != null && iCommonsNavigableMap.isNotEmpty()) {
            IValidationExecutorSet iValidationExecutorSet = (IValidationExecutorSet)iCommonsNavigableMap.getFirstValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved latest version of '" + string + ":" + string2 + "' to '" + ((DVRCoordinate)iValidationExecutorSet.getID()).getVersionString() + "'");
            }
            return iValidationExecutorSet;
        }
        return null;
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getLatestVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set) {
        return this._getLatestVersion(string, string2, set, true);
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getLatestReleaseVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set) {
        return this._getLatestVersion(string, string2, set, false);
    }

    @Nullable
    private IValidationExecutorSet<SOURCETYPE> _getLatestActiveVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set, boolean bl, @Nullable OffsetDateTime offsetDateTime) {
        ICommonsNavigableMap<DVRCoordinate, IValidationExecutorSet<SOURCETYPE>> iCommonsNavigableMap = this._getAllMatchingVES(string, string2, DVRVersion.getStaticVersionAcceptor(set, (boolean)bl), Comparator.reverseOrder());
        if (iCommonsNavigableMap != null && iCommonsNavigableMap.isNotEmpty()) {
            OffsetDateTime offsetDateTime2 = offsetDateTime != null ? offsetDateTime : PDTFactory.getCurrentOffsetDateTime();
            IValidationExecutorSet iValidationExecutorSet2 = (IValidationExecutorSet)CollectionHelper.findFirst((Iterable)iCommonsNavigableMap.values(), iValidationExecutorSet -> iValidationExecutorSet.getStatus().isValidPer(offsetDateTime2));
            if (iValidationExecutorSet2 != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolved latest active version of '" + string + ":" + string2 + "' to '" + ((DVRCoordinate)iValidationExecutorSet2.getID()).getVersionString() + "'");
                }
                return iValidationExecutorSet2;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getLatestActiveVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set, @Nullable OffsetDateTime offsetDateTime) {
        return this._getLatestActiveVersion(string, string2, set, true, offsetDateTime);
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getLatestReleaseActiveVersion(@Nullable String string, @Nullable String string2, @Nullable Set<String> set, @Nullable OffsetDateTime offsetDateTime) {
        return this._getLatestActiveVersion(string, string2, set, false, offsetDateTime);
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getOfID(@Nullable DVRCoordinate dVRCoordinate) {
        return this.getOfID(dVRCoordinate, null);
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getOfID(@Nullable DVRCoordinate dVRCoordinate, @Nullable OffsetDateTime offsetDateTime) {
        if (dVRCoordinate == null) {
            return null;
        }
        Object object = (IValidationExecutorSet)this.m_aRWLock.readLockedGet(() -> (IValidationExecutorSet)this.m_aMap.get((Object)dVRCoordinate));
        if (object == null && dVRCoordinate.getVersionObj().isPseudoVersion()) {
            if (this.isResolvePseudoVersions()) {
                IDVRPseudoVersion iDVRPseudoVersion;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying to resolve pseudo version latest of '" + dVRCoordinate.getAsSingleID() + "'");
                }
                if ((iDVRPseudoVersion = dVRCoordinate.getVersionObj().getPseudoVersion()).equals(DVRPseudoVersionRegistry.OLDEST)) {
                    object = this.getOldestVersion(dVRCoordinate.getGroupID(), dVRCoordinate.getArtifactID(), (Set)null);
                } else if (iDVRPseudoVersion.equals(DVRPseudoVersionRegistry.LATEST)) {
                    object = this.getLatestVersion(dVRCoordinate.getGroupID(), dVRCoordinate.getArtifactID(), (Set)null);
                } else if (iDVRPseudoVersion.equals(DVRPseudoVersionRegistry.LATEST_RELEASE)) {
                    object = this.getLatestReleaseVersion(dVRCoordinate.getGroupID(), dVRCoordinate.getArtifactID(), (Set)null);
                } else if (iDVRPseudoVersion.equals(PhivePseudoVersionRegistrarSPIImpl.LATEST_ACTIVE)) {
                    object = this.getLatestActiveVersion(dVRCoordinate.getGroupID(), dVRCoordinate.getArtifactID(), (Set)null, offsetDateTime);
                } else if (iDVRPseudoVersion.equals(PhivePseudoVersionRegistrarSPIImpl.LATEST_RELEASE_ACTIVE)) {
                    object = this.getLatestReleaseActiveVersion(dVRCoordinate.getGroupID(), dVRCoordinate.getArtifactID(), (Set)null, offsetDateTime);
                } else {
                    LOGGER.warn("The pseudo version " + iDVRPseudoVersion + " is currently not supported.");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The pseudo version resolving is disabled.");
            }
        }
        return object;
    }

    @Nonnull
    public EChange removeAll() {
        return this.removeAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange removeAll(boolean bl) {
        EChange eChange = EChange.UNCHANGED;
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMap.isNotEmpty()) {
                eChange = EChange.CHANGED;
                if (bl) {
                    for (IValidationExecutorSet iValidationExecutorSet : this.m_aMap.values()) {
                        if (!(iValidationExecutorSet instanceof ValidationExecutorSet)) continue;
                        ((ValidationExecutorSet)iValidationExecutorSet).removeAllExecutors();
                    }
                }
                this.m_aMap.clear();
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (eChange.isChanged() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully removed all validatione executor sets" + (bl ? " and cleaned all VES." : "."));
        }
        return eChange;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }

    private /* synthetic */ void lambda$_getAllMatchingVES$7(String string, String string2, Predicate predicate, ICommonsNavigableMap iCommonsNavigableMap) {
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            DVRCoordinate dVRCoordinate = (DVRCoordinate)entry.getKey();
            if (!dVRCoordinate.getGroupID().equals(string) || !dVRCoordinate.getArtifactID().equals(string2) || !predicate.test(dVRCoordinate.getVersionObj())) continue;
            iCommonsNavigableMap.put(entry);
        }
    }
}

