/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.executorset.status;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.phive.api.executorset.status.EValidationExecutorStatusType;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.api.executorset.status.ValidationExecutorSetStatusHistoryItem;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class ValidationExecutorSetStatus
implements IValidationExecutorSetStatus {
    private final OffsetDateTime m_aStatusLastModDT;
    private final EValidationExecutorStatusType m_eType;
    private final OffsetDateTime m_aValidFrom;
    private final OffsetDateTime m_aValidTo;
    private final String m_sDeprecationReason;
    private final DVRCoordinate m_aReplacementVESID;
    private final ICommonsList<ValidationExecutorSetStatusHistoryItem> m_aHistoryItems;

    public ValidationExecutorSetStatus(@Nonnull OffsetDateTime offsetDateTime, @Nonnull EValidationExecutorStatusType eValidationExecutorStatusType, @Nullable OffsetDateTime offsetDateTime2, @Nullable OffsetDateTime offsetDateTime3, @Nullable String string, @Nullable DVRCoordinate dVRCoordinate, @Nullable ICommonsList<ValidationExecutorSetStatusHistoryItem> iCommonsList) {
        ValueEnforcer.notNull((Object)offsetDateTime, (String)"StatusLastModDT");
        ValueEnforcer.notNull((Object)((Object)eValidationExecutorStatusType), (String)"Type");
        this.m_aStatusLastModDT = PDTFactory.getWithMillisOnly((OffsetDateTime)offsetDateTime);
        this.m_eType = eValidationExecutorStatusType;
        this.m_aValidFrom = PDTFactory.getWithMillisOnly((OffsetDateTime)offsetDateTime2);
        this.m_aValidTo = PDTFactory.getWithMillisOnly((OffsetDateTime)offsetDateTime3);
        this.m_sDeprecationReason = string;
        this.m_aReplacementVESID = dVRCoordinate;
        this.m_aHistoryItems = new CommonsArrayList(iCommonsList);
    }

    @Override
    @Nonnull
    public final OffsetDateTime getStatusLastModification() {
        return this.m_aStatusLastModDT;
    }

    @Override
    @Nonnull
    public final EValidationExecutorStatusType getType() {
        return this.m_eType;
    }

    @Override
    @Nullable
    public final OffsetDateTime getValidFrom() {
        return this.m_aValidFrom;
    }

    @Override
    @Nullable
    public final OffsetDateTime getValidTo() {
        return this.m_aValidTo;
    }

    @Override
    @Nullable
    public final String getDeprecationReason() {
        return this.m_sDeprecationReason;
    }

    @Override
    @Nullable
    public DVRCoordinate getReplacementVESID() {
        return this.m_aReplacementVESID;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableObject
    public ICommonsList<ValidationExecutorSetStatusHistoryItem> historyItems() {
        return this.m_aHistoryItems;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<ValidationExecutorSetStatusHistoryItem> getAllHistoryItems() {
        return (ICommonsList)this.m_aHistoryItems.getClone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationExecutorSetStatus validationExecutorSetStatus = (ValidationExecutorSetStatus)object;
        return this.m_aStatusLastModDT.equals(validationExecutorSetStatus.m_aStatusLastModDT) && this.m_eType.equals((Object)validationExecutorSetStatus.m_eType) && EqualsHelper.equals((Object)this.m_aValidFrom, (Object)validationExecutorSetStatus.m_aValidFrom) && EqualsHelper.equals((Object)this.m_aValidTo, (Object)validationExecutorSetStatus.m_aValidTo) && EqualsHelper.equals((Object)this.m_sDeprecationReason, (Object)validationExecutorSetStatus.m_sDeprecationReason) && EqualsHelper.equals((Object)this.m_aReplacementVESID, (Object)validationExecutorSetStatus.m_aReplacementVESID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aStatusLastModDT).append((Enum)this.m_eType).append((Object)this.m_aValidFrom).append((Object)this.m_aValidTo).append((Object)this.m_sDeprecationReason).append((Object)this.m_aReplacementVESID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("StatusLastModDT", (Object)this.m_aStatusLastModDT).append("Type", (Enum)this.m_eType).append("ValidFrom", (Object)this.m_aValidFrom).append("ValidTo", (Object)this.m_aValidTo).append("DeprecationReason", (Object)this.m_sDeprecationReason).append("ReplacementVESID", (Object)this.m_aReplacementVESID).append("HistoryItems", this.m_aHistoryItems).getToString();
    }

    @Nonnull
    public static ValidationExecutorSetStatus createValidNow() {
        return ValidationExecutorSetStatus.createDeprecatedNow(false);
    }

    @Nonnull
    public static ValidationExecutorSetStatus createValidAt(@Nonnull OffsetDateTime offsetDateTime) {
        return ValidationExecutorSetStatus.createDeprecated(offsetDateTime, false);
    }

    @Nonnull
    public static ValidationExecutorSetStatus createDeprecatedNow(boolean bl) {
        return ValidationExecutorSetStatus.createDeprecated(PDTFactory.getCurrentOffsetDateTime(), bl);
    }

    @Nonnull
    public static ValidationExecutorSetStatus createDeprecated(@Nonnull OffsetDateTime offsetDateTime, boolean bl) {
        return new ValidationExecutorSetStatus(offsetDateTime, bl ? EValidationExecutorStatusType.DEPRECATED : EValidationExecutorStatusType.VALID, null, null, null, null, (ICommonsList<ValidationExecutorSetStatusHistoryItem>)((ICommonsList)null));
    }
}

