/*
 * Copyright (C) 2014-2025 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.phive.api.source;

import javax.annotation.Nullable;

import com.helger.commons.io.ByteArrayWrapper;

/**
 * Binary validation source.
 *
 * @author Philip Helger
 * @since 6.0.3
 */
public interface IValidationSourceBinary extends IValidationSource
{
  String VALIDATION_SOURCE_TYPE = "binary";

  /**
   * @return The bytes to be validated. May be <code>null</code>.
   */
  @Nullable
  ByteArrayWrapper getBytes ();
}
