/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.execute;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EValidity;
import com.helger.phive.api.execute.IValidationExecutionManager;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.result.ValidationResult;
import com.helger.phive.api.result.ValidationResultList;
import com.helger.phive.api.source.IValidationSource;
import com.helger.phive.api.validity.EExtendedValidity;
import com.helger.phive.api.validity.IValidityDeterminator;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ValidationExecutionManager<SOURCETYPE extends IValidationSource>
implements IValidationExecutionManager<SOURCETYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationExecutionManager.class);
    private final IValidityDeterminator<SOURCETYPE> m_aValidityDeterminator;
    private final ICommonsList<IValidationExecutor<SOURCETYPE>> m_aExecutors = new CommonsArrayList();

    public ValidationExecutionManager(@Nonnull IValidityDeterminator<SOURCETYPE> iValidityDeterminator) {
        ValueEnforcer.notNull(iValidityDeterminator, (String)"ValidityDeterminator");
        this.m_aValidityDeterminator = iValidityDeterminator;
    }

    public ValidationExecutionManager(@Nonnull IValidityDeterminator<SOURCETYPE> iValidityDeterminator, @Nullable Iterable<? extends IValidationExecutor<SOURCETYPE>> iterable) {
        this(iValidityDeterminator);
        this.addExecutors(iterable);
    }

    @Override
    @Nonnull
    public final IValidityDeterminator<SOURCETYPE> getValidityDeterminator() {
        return this.m_aValidityDeterminator;
    }

    @Nonnull
    public final ValidationExecutionManager<SOURCETYPE> addExecutor(@Nonnull IValidationExecutor<SOURCETYPE> iValidationExecutor) {
        ValueEnforcer.notNull(iValidationExecutor, (String)"Executor");
        this.m_aExecutors.add(iValidationExecutor);
        return this;
    }

    @Nonnull
    public final ValidationExecutionManager<SOURCETYPE> addExecutors(@Nullable Iterable<? extends IValidationExecutor<SOURCETYPE>> iterable) {
        if (iterable != null) {
            for (IValidationExecutor<SOURCETYPE> iValidationExecutor : iterable) {
                this.addExecutor(iValidationExecutor);
            }
        }
        return this;
    }

    @Nonnegative
    public int getExecutorCount() {
        return this.m_aExecutors.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IValidationExecutor<SOURCETYPE>> getAllExecutors() {
        return (ICommonsList)this.m_aExecutors.getClone();
    }

    @Nonnull
    public ICommonsIterable<IValidationExecutor<SOURCETYPE>> getExecutors() {
        return this.m_aExecutors;
    }

    @Override
    public void executeValidation(@Nonnull SOURCETYPE SOURCETYPE, @Nonnull ValidationResultList validationResultList, @Nullable Locale locale) {
        ValueEnforcer.notNull(SOURCETYPE, (String)"Source");
        ValueEnforcer.notNull((Object)((Object)validationResultList), (String)"ValidationResults");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing validation on source " + String.valueOf(SOURCETYPE) + (String)(locale == null ? "" : " and locale " + String.valueOf(locale)));
        }
        boolean bl = false;
        for (IValidationExecutor iValidationExecutor : this.getAllExecutors()) {
            if (bl) {
                validationResultList.add(ValidationResult.createSkippedResult(iValidationExecutor.getValidationArtefact()));
                continue;
            }
            ValidationResult validationResult = iValidationExecutor.applyValidation(SOURCETYPE, locale);
            assert (validationResult != null);
            validationResultList.add(validationResult);
            EExtendedValidity eExtendedValidity = this.m_aValidityDeterminator.getValidity(iValidationExecutor, validationResult.getErrorList());
            if (!eExtendedValidity.isInvalid() || !iValidationExecutor.isStopValidationOnError()) continue;
            bl = true;
        }
    }

    @Override
    @Nonnull
    public EValidity executeFastValidation(@Nonnull SOURCETYPE SOURCETYPE) {
        ValueEnforcer.notNull(SOURCETYPE, (String)"Source");
        for (IValidationExecutor iValidationExecutor : this.getAllExecutors()) {
            ValidationResult validationResult;
            EExtendedValidity eExtendedValidity = this.m_aValidityDeterminator.getValidity(iValidationExecutor, (validationResult = iValidationExecutor.applyValidation(SOURCETYPE, null)).getErrorList());
            if (!eExtendedValidity.isInvalid()) continue;
            return EValidity.INVALID;
        }
        return EValidity.VALID;
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="10.0.0")
    public static <ST extends IValidationSource> ValidationResultList executeValidation(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST) {
        return ValidationExecutionManager.executeValidation(IValidityDeterminator.createDefault(), iValidationExecutorSet, ST);
    }

    @Nonnull
    public static <ST extends IValidationSource> ValidationResultList executeValidation(@Nonnull IValidityDeterminator<ST> iValidityDeterminator, @Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST) {
        return new ValidationExecutionManager<ST>(iValidityDeterminator, iValidationExecutorSet).executeValidation(ST);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="10.0.0")
    public static <ST extends IValidationSource> ValidationResultList executeValidation(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST, @Nullable Locale locale) {
        return ValidationExecutionManager.executeValidation(IValidityDeterminator.createDefault(), iValidationExecutorSet, ST, locale);
    }

    @Nonnull
    public static <ST extends IValidationSource> ValidationResultList executeValidation(@Nonnull IValidityDeterminator<ST> iValidityDeterminator, @Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST, @Nullable Locale locale) {
        return new ValidationExecutionManager<ST>(iValidityDeterminator, iValidationExecutorSet).executeValidation(ST, locale);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="10.0.0")
    public static <ST extends IValidationSource> void executeValidation(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST, @Nonnull ValidationResultList validationResultList, @Nullable Locale locale) {
        ValidationExecutionManager.executeValidation(IValidityDeterminator.createDefault(), iValidationExecutorSet, ST, validationResultList, locale);
    }

    @Nonnull
    public static <ST extends IValidationSource> void executeValidation(@Nonnull IValidityDeterminator<ST> iValidityDeterminator, @Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST, @Nonnull ValidationResultList validationResultList, @Nullable Locale locale) {
        new ValidationExecutionManager<ST>(iValidityDeterminator, iValidationExecutorSet).executeValidation(ST, validationResultList, locale);
    }

    @Nonnull
    public static <ST extends IValidationSource> EValidity executeFastValidation(@Nonnull IValidityDeterminator<ST> iValidityDeterminator, @Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST) {
        return new ValidationExecutionManager<ST>(iValidityDeterminator, iValidationExecutorSet).executeFastValidation(ST);
    }
}

