/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.executor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.phive.api.artefact.IValidationArtefact;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.result.ValidationResult;
import com.helger.phive.api.source.IValidationSource;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractValidationExecutor<SOURCETYPE extends IValidationSource, IMPLTYPE extends AbstractValidationExecutor<SOURCETYPE, IMPLTYPE>>
implements IValidationExecutor<SOURCETYPE>,
IGenericImplTrait<IMPLTYPE> {
    private final IValidationArtefact m_aValidationArtefact;
    private boolean m_bStopValidationOnError;

    public AbstractValidationExecutor(@Nonnull IValidationArtefact iValidationArtefact) {
        ValueEnforcer.notNull((Object)iValidationArtefact, (String)"ValidationArtefact");
        this.m_aValidationArtefact = iValidationArtefact;
        this.m_bStopValidationOnError = iValidationArtefact.getValidationType().isStopValidationOnError();
    }

    @Override
    @Nonnull
    public final IValidationArtefact getValidationArtefact() {
        return this.m_aValidationArtefact;
    }

    @Override
    public final boolean isStopValidationOnError() {
        return this.m_bStopValidationOnError;
    }

    @Nonnull
    public final IMPLTYPE setStopValidationOnError(boolean bl) {
        this.m_bStopValidationOnError = bl;
        return (IMPLTYPE)((AbstractValidationExecutor)this.thisAsT());
    }

    @Nonnull
    protected final ValidationResult createValidationResult(@Nonnull IErrorList iErrorList, @Nonnegative long l) {
        return new ValidationResult(this.m_aValidationArtefact, iErrorList, l);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractValidationExecutor abstractValidationExecutor = (AbstractValidationExecutor)object;
        return this.m_aValidationArtefact.equals(abstractValidationExecutor.m_aValidationArtefact) && this.m_bStopValidationOnError == abstractValidationExecutor.m_bStopValidationOnError;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aValidationArtefact).append(this.m_bStopValidationOnError).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ValidationArtefact", (Object)this.m_aValidationArtefact).append("StopValidationOnError", this.m_bStopValidationOnError).getToString();
    }
}

