/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.diver.api.coord.DVRCoordinate;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PhiveTestFile {
    private final IReadableResource m_aResource;
    private final DVRCoordinate m_aVESID;
    private final ICommonsSet<String> m_aExpectedErrorIDs;

    public PhiveTestFile(@Nonnull IReadableResource iReadableResource, @Nonnull DVRCoordinate dVRCoordinate, @Nullable Set<String> set) {
        this.m_aResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_aVESID = (DVRCoordinate)ValueEnforcer.notNull((Object)dVRCoordinate, (String)"VESID");
        this.m_aExpectedErrorIDs = new CommonsHashSet(set);
    }

    @Nonnull
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    public DVRCoordinate getVESID() {
        return this.m_aVESID;
    }

    public boolean isGoodCase() {
        return this.m_aExpectedErrorIDs.isEmpty();
    }

    public boolean isBadCase() {
        return this.m_aExpectedErrorIDs.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllExpectedErrorIDs() {
        return (ICommonsSet)this.m_aExpectedErrorIDs.getClone();
    }

    @Nonnull
    public static PhiveTestFile createGoodCase(@Nonnull IReadableResource iReadableResource, @Nonnull DVRCoordinate dVRCoordinate) {
        return new PhiveTestFile(iReadableResource, dVRCoordinate, null);
    }
}

