/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.xml.xsd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.phive.api.EValidationType;
import com.helger.phive.api.IValidationType;
import com.helger.phive.api.artefact.IValidationArtefact;
import com.helger.phive.api.artefact.ValidationArtefact;
import com.helger.phive.api.executor.AbstractValidationExecutor;
import com.helger.phive.api.result.ValidationResult;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.source.ValidationSourceXML;
import com.helger.phive.xml.xsd.XSDPartialContext;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class ValidationExecutorXSDPartial
extends AbstractValidationExecutor<IValidationSourceXML, ValidationExecutorXSDPartial> {
    private final Supplier<? extends Schema> m_aSchemaProvider;
    private final XSDPartialContext m_aPartialContext;

    public ValidationExecutorXSDPartial(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull Supplier<? extends Schema> supplier, @Nonnull XSDPartialContext xSDPartialContext) {
        super(iValidationArtefact);
        ValueEnforcer.isTrue(() -> iValidationArtefact.getValidationType().getBaseType().isXSD(), (String)"Artifact is not an XSD");
        ValueEnforcer.isTrue(() -> iValidationArtefact.getValidationType().isContextRequired(), (String)"Artifact must require a validation context");
        ValueEnforcer.notNull(supplier, (String)"SchemaProvider");
        ValueEnforcer.notNull((Object)xSDPartialContext, (String)"PartialContext");
        this.m_aSchemaProvider = supplier;
        this.m_aPartialContext = xSDPartialContext;
        this.setStopValidationOnError(true);
    }

    @Nonnull
    public final XSDPartialContext getContext() {
        return this.m_aPartialContext;
    }

    @Nonnull
    public ValidationResult applyValidation(@Nonnull IValidationSourceXML iValidationSourceXML, @Nullable Locale locale) {
        NodeList nodeList;
        ValueEnforcer.notNull((Object)iValidationSourceXML, (String)"Source");
        IValidationArtefact iValidationArtefact = this.getValidationArtefact();
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            nodeList = (NodeList)this.m_aPartialContext.getXPathExpression().evaluate(iValidationSourceXML.getNode(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalStateException(xPathExpressionException);
        }
        ErrorList errorList = new ErrorList();
        int n = nodeList.getLength();
        if (this.m_aPartialContext.hasMinNodeCount() && n < this.m_aPartialContext.getMinNodeCount()) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderFatalError().errorLocation(iValidationArtefact.getRuleResourcePath())).errorText("The minimum number of result nodes (" + this.m_aPartialContext.getMinNodeCount() + ") is not met")).build());
        }
        if (this.m_aPartialContext.hasMaxNodeCount() && n > this.m_aPartialContext.getMaxNodeCount()) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderFatalError().errorLocation(iValidationArtefact.getRuleResourcePath())).errorText("The maximum number of result nodes (" + this.m_aPartialContext.getMaxNodeCount() + ") is not met")).build());
        }
        if (n == 0) {
            return this.createValidationResult((IErrorList)errorList, stopWatch.stopAndGetMillis());
        }
        Schema schema = this.m_aSchemaProvider.get();
        assert (schema != null);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ValidationSourceXML validationSourceXML = new ValidationSourceXML(iValidationSourceXML.getSystemID(), nodeList.item(i), true);
            try {
                XMLSchemaValidationHelper.validate((Schema)schema, (Source)validationSourceXML.getAsTransformSource(), (ErrorList)errorList, (Locale)locale);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getCause() instanceof SAXParseException) {
                    errorList.add((Object)AbstractSAXErrorHandler.getSaxParseError((IErrorLevel)EErrorLevel.FATAL_ERROR, (SAXParseException)((SAXParseException)illegalArgumentException.getCause())));
                    continue;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builderFatalError().errorLocation(iValidationArtefact.getRuleResourcePath())).errorFieldName("Context[" + i + "]")).errorText("The document to be validated is not an XML document")).linkedException((Throwable)illegalArgumentException)).build());
            }
        }
        return this.createValidationResult((IErrorList)errorList, stopWatch.stopAndGetMillis());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ValidationExecutorXSDPartial getClone() {
        ValidationExecutorXSDPartial validationExecutorXSDPartial = new ValidationExecutorXSDPartial(this.getValidationArtefact(), this.m_aSchemaProvider, this.m_aPartialContext);
        validationExecutorXSDPartial.setStopValidationOnError(this.isStopValidationOnError());
        return validationExecutorXSDPartial;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("SchemaProvider", this.m_aSchemaProvider).append("PartialContext", (Object)this.m_aPartialContext).getToString();
    }

    @Nonnull
    public static ValidationExecutorXSDPartial create(@Nonnull IReadableResource iReadableResource, @Nonnull XSDPartialContext xSDPartialContext) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XSDRes");
        return new ValidationExecutorXSDPartial((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.PARTIAL_XSD, iReadableResource), () -> XMLSchemaCache.getInstance().getSchema(iReadableResource), xSDPartialContext);
    }

    @Nonnull
    public static ValidationExecutorXSDPartial create(@Nonnull @Nonempty List<? extends IReadableResource> list, @Nonnull XSDPartialContext xSDPartialContext) {
        ValueEnforcer.notEmptyNoNullValue(list, (String)"XSDRes");
        return new ValidationExecutorXSDPartial((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.PARTIAL_XSD, list.get(list.size() - 1)), () -> XMLSchemaCache.getInstance().getSchema((Collection)list), xSDPartialContext);
    }
}

