/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.rules.api;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.xml.schematron.ValidationExecutorSchematron;
import com.helger.ubl20.UBL20NamespaceContext;
import com.helger.ubl21.UBL21NamespaceContext;
import com.helger.ubl22.UBL22NamespaceContext;
import com.helger.ubl23.UBL23NamespaceContext;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PhiveRulesUBLHelper {
    private PhiveRulesUBLHelper() {
    }

    @Nonnull
    @ReturnsMutableObject
    public static MapBasedNamespaceContext createUBL21NSContext(@Nonnull String string) {
        MapBasedNamespaceContext mapBasedNamespaceContext = UBL21NamespaceContext.getInstance().getClone();
        mapBasedNamespaceContext.addMapping("", string);
        mapBasedNamespaceContext.addMapping("ubl", string);
        return mapBasedNamespaceContext;
    }

    @Nonnull
    public static ValidationExecutorSchematron createXSLT_UBL20(@Nonnull IReadableResource iReadableResource) {
        return PhiveRulesHelper.createXSLT(iReadableResource, (IIterableNamespaceContext)UBL20NamespaceContext.getInstance());
    }

    @Nonnull
    public static ValidationExecutorSchematron createXSLT_UBL21(@Nonnull IReadableResource iReadableResource) {
        return PhiveRulesHelper.createXSLT(iReadableResource, (IIterableNamespaceContext)UBL21NamespaceContext.getInstance());
    }

    @Nonnull
    public static ValidationExecutorSchematron createXSLT_UBL22(@Nonnull IReadableResource iReadableResource) {
        return PhiveRulesHelper.createXSLT(iReadableResource, (IIterableNamespaceContext)UBL22NamespaceContext.getInstance());
    }

    @Nonnull
    public static ValidationExecutorSchematron createXSLT_UBL23(@Nonnull IReadableResource iReadableResource) {
        return PhiveRulesHelper.createXSLT(iReadableResource, (IIterableNamespaceContext)UBL23NamespaceContext.getInstance());
    }
}

