/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.cii;

import com.helger.cii.d16b.CCIID16B;
import com.helger.cii.d22b.CCIID22B;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CIIValidation {
    public static final String GROUP_ID = "un.unece.uncefact";
    public static final String VERSION_D16B = "D16B";
    public static final String VERSION_D22B = "D22B";
    public static final DVRCoordinate VID_CII_D16B_CROSSINDUSTRYINVOICE = PhiveRulesHelper.createCoordinate((String)"un.unece.uncefact", (String)"crossindustryinvoice", (String)"D16B");
    public static final DVRCoordinate VID_CII_D22B_CROSSINDUSTRYINVOICE = PhiveRulesHelper.createCoordinate((String)"un.unece.uncefact", (String)"crossindustryinvoice", (String)"D22B");

    private CIIValidation() {
    }

    public static void initCII(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        CIIValidation.initCIID16B(iValidationExecutorSetRegistry);
        CIIValidation.initCIID22B(iValidationExecutorSetRegistry);
    }

    public static void initCIID16B(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_CII_D16B_CROSSINDUSTRYINVOICE, (String)"CII CrossIndustryInvoice D16B", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)CCIID16B.getXSDResource())}));
    }

    public static void initCIID22B(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_CII_D22B_CROSSINDUSTRYINVOICE, (String)"CII CrossIndustryInvoice D22B", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)CCIID22B.getXSDResource())}));
    }
}

