/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PeppolValidationDirectory {
    public static final String GROUP_ID = "eu.peppol.directory";
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_BUSINESS_CARD_V1 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.directory", (String)"businesscard", (String)"1.0.0");
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_BUSINESS_CARD_V2 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.directory", (String)"businesscard", (String)"2.0.0");
    public static final DVRCoordinate VID_OPENPEPPOL_BUSINESS_CARD_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.directory", (String)"businesscard", (String)"3.0.0");

    private PeppolValidationDirectory() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidationDirectory.class.getClassLoader();
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        ClassPathResource classPathResource = new ClassPathResource("external/schemas/peppol-directory-business-card-20160112.xsd", PeppolValidationDirectory._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BUSINESS_CARD_V1, (String)"Peppol Directory BusinessCard v1", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)classPathResource)}));
        classPathResource = new ClassPathResource("external/schemas/peppol-directory-business-card-20161123.xsd", PeppolValidationDirectory._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BUSINESS_CARD_V2, (String)"Peppol Directory BusinessCard v2", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)classPathResource)}));
        classPathResource = new ClassPathResource("external/schemas/peppol-directory-business-card-20180621.xsd", PeppolValidationDirectory._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BUSINESS_CARD_V3, (String)"Peppol Directory BusinessCard v3", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)classPathResource)}));
    }
}

