/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.zugferd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.diver.api.version.DVRVersion;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.ValidationExecutorSetAlias;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.en16931.EN16931Validation;
import com.helger.phive.rules.api.PhiveRulesCIIHelper;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.xml.schematron.ValidationExecutorSchematron;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.phive.zugferd.EZugferdProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ZugferdValidation {
    public static final String GROUP_ID_ZUGFERD = "de.zugferd";
    public static final String GROUP_ID_FACTUR_X = "fr.factur-x";
    public static final DVRCoordinate VID_ZUGFERD_2_0_1_MINIMUM = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.MINIMUM.getArtifactID(), (String)"2.0.1");
    public static final DVRCoordinate VID_ZUGFERD_2_0_1_BASIC_WL = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC_WL.getArtifactID(), (String)"2.0.1");
    public static final DVRCoordinate VID_ZUGFERD_2_0_1_BASIC = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC.getArtifactID(), (String)"2.0.1");
    public static final DVRCoordinate VID_ZUGFERD_2_0_1_EN16931 = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EN16931.getArtifactID(), (String)"2.0.1");
    public static final DVRCoordinate VID_ZUGFERD_2_0_1_EXTENDED = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EXTENDED.getArtifactID(), (String)"2.0.1");
    public static final DVRCoordinate VID_ZUGFERD_2_1_MINIMUM = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.MINIMUM.getArtifactID(), (String)"2.1");
    public static final DVRCoordinate VID_ZUGFERD_2_1_BASIC_WL = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC_WL.getArtifactID(), (String)"2.1");
    public static final DVRCoordinate VID_ZUGFERD_2_1_BASIC = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC.getArtifactID(), (String)"2.1");
    public static final DVRCoordinate VID_ZUGFERD_2_1_EN16931 = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EN16931.getArtifactID(), (String)"2.1");
    public static final DVRCoordinate VID_ZUGFERD_2_1_EXTENDED = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EXTENDED.getArtifactID(), (String)"2.1");
    public static final DVRCoordinate VID_ZUGFERD_2_2_MINIMUM = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.MINIMUM.getArtifactID(), (String)"2.2");
    public static final DVRCoordinate VID_ZUGFERD_2_2_BASIC_WL = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC_WL.getArtifactID(), (String)"2.2");
    public static final DVRCoordinate VID_ZUGFERD_2_2_BASIC = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC.getArtifactID(), (String)"2.2");
    public static final DVRCoordinate VID_ZUGFERD_2_2_EN16931 = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EN16931.getArtifactID(), (String)"2.2");
    public static final DVRCoordinate VID_ZUGFERD_2_2_EXTENDED = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EXTENDED.getArtifactID(), (String)"2.2");
    public static final DVRCoordinate VID_ZUGFERD_2_3_2_MINIMUM = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.MINIMUM.getArtifactID(), (String)"2.3.2");
    public static final DVRCoordinate VID_ZUGFERD_2_3_2_BASIC_WL = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC_WL.getArtifactID(), (String)"2.3.2");
    public static final DVRCoordinate VID_ZUGFERD_2_3_2_BASIC = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.BASIC.getArtifactID(), (String)"2.3.2");
    public static final DVRCoordinate VID_ZUGFERD_2_3_2_EN16931 = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EN16931.getArtifactID(), (String)"2.3.2");
    public static final DVRCoordinate VID_ZUGFERD_2_3_2_EXTENDED = PhiveRulesHelper.createCoordinate((String)"de.zugferd", (String)EZugferdProfile.EXTENDED.getArtifactID(), (String)"2.3.2");
    private static final ICommonsMap<DVRVersion, DVRVersion> ZUGFERD_TO_FACTURX_MAP = new CommonsHashMap();

    private ZugferdValidation() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return ZugferdValidation.class.getClassLoader();
    }

    @Nullable
    public static DVRCoordinate getMappedFacturXVESID(@Nonnull DVRCoordinate dVRCoordinate) {
        ValueEnforcer.notNull((Object)dVRCoordinate, (String)"ZugferdVESID");
        DVRVersion dVRVersion = (DVRVersion)ZUGFERD_TO_FACTURX_MAP.get((Object)dVRCoordinate.getVersionObj());
        if (dVRVersion == null) {
            return null;
        }
        return new DVRCoordinate(GROUP_ID_FACTUR_X, dVRCoordinate.getArtifactID(), dVRVersion);
    }

    private static void _registerFacturXAlias(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry, @Nonnull EZugferdProfile eZugferdProfile, @Nonnull ValidationExecutorSet<IValidationSourceXML> validationExecutorSet) {
        DVRCoordinate dVRCoordinate = ZugferdValidation.getMappedFacturXVESID(validationExecutorSet.getID());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)new ValidationExecutorSetAlias(dVRCoordinate, "Factur-X " + dVRCoordinate.getVersionString() + " (" + eZugferdProfile.getDisplayName() + ")", validationExecutorSet));
    }

    public static void initZugferd(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValidationExecutorSet validationExecutorSet;
        IValidationExecutorSetStatus iValidationExecutorSetStatus;
        String string;
        DVRCoordinate dVRCoordinate;
        ValidationExecutorSchematron validationExecutorSchematron;
        String string2;
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        for (EZugferdProfile eZugferdProfile : EZugferdProfile.values()) {
            switch (eZugferdProfile) {
                case MINIMUM: 
                case BASIC_WL: {
                    string2 = "basicwl_minimum";
                    break;
                }
                case BASIC: 
                case EN16931: {
                    string2 = "en16931";
                    break;
                }
                case EXTENDED: {
                    string2 = "extended";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            validationExecutorSchematron = PhiveRulesCIIHelper.createXSLT_CII_D16B((IReadableResource)new ClassPathResource("/external/schematron/2.0.1/zugferd2p0_" + string2 + ".xslt", ZugferdValidation._getCL()));
            dVRCoordinate = PhiveRulesHelper.createCoordinate((String)GROUP_ID_ZUGFERD, (String)eZugferdProfile.getArtifactID(), (String)"2.0.1");
            string = "ZUGFeRD 2.0.1 (" + eZugferdProfile.getDisplayName() + ")";
            iValidationExecutorSetStatus = PhiveRulesHelper.createSimpleStatus((boolean)true);
            validationExecutorSet = ValidationExecutorSet.create((DVRCoordinate)dVRCoordinate, (String)string, (IValidationExecutorSetStatus)iValidationExecutorSetStatus, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)new ClassPathResource("/external/schemas/2.0.1/" + string2 + "/zugferd2p0_" + string2 + ".xsd", ZugferdValidation._getCL())), validationExecutorSchematron});
            iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)validationExecutorSet);
            ZugferdValidation._registerFacturXAlias(iValidationExecutorSetRegistry, eZugferdProfile, (ValidationExecutorSet<IValidationSourceXML>)validationExecutorSet);
        }
        for (EZugferdProfile eZugferdProfile : EZugferdProfile.values()) {
            string2 = eZugferdProfile == EZugferdProfile.BASIC_WL ? "BASIC-WL" : eZugferdProfile.getFilenameSuffix();
            validationExecutorSchematron = PhiveRulesCIIHelper.createXSLT_CII_D16B((IReadableResource)new ClassPathResource("/external/schematron/2.1/FACTUR-X_" + string2 + ".xslt", ZugferdValidation._getCL()));
            dVRCoordinate = PhiveRulesHelper.createCoordinate((String)GROUP_ID_ZUGFERD, (String)eZugferdProfile.getArtifactID(), (String)"2.1");
            string = "ZUGFeRD 2.1 (" + eZugferdProfile.getDisplayName() + ")";
            iValidationExecutorSetStatus = PhiveRulesHelper.createSimpleStatus((boolean)true);
            validationExecutorSet = eZugferdProfile == EZugferdProfile.EN16931 ? ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSetRegistry.getOfID(EN16931Validation.VID_CII_131), (DVRCoordinate)dVRCoordinate, (String)string, (IValidationExecutorSetStatus)iValidationExecutorSetStatus, (IValidationExecutor[])new IValidationExecutor[]{validationExecutorSchematron}) : ValidationExecutorSet.create((DVRCoordinate)dVRCoordinate, (String)string, (IValidationExecutorSetStatus)iValidationExecutorSetStatus, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)new ClassPathResource("/external/schemas/2.1/" + eZugferdProfile.getFolderName() + "/FACTUR-X_" + string2 + ".xsd", ZugferdValidation._getCL())), validationExecutorSchematron});
            iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)validationExecutorSet);
            ZugferdValidation._registerFacturXAlias(iValidationExecutorSetRegistry, eZugferdProfile, (ValidationExecutorSet<IValidationSourceXML>)validationExecutorSet);
        }
        for (EZugferdProfile eZugferdProfile : EZugferdProfile.values()) {
            string2 = eZugferdProfile == EZugferdProfile.BASIC_WL ? "BASIC-WL" : eZugferdProfile.getFilenameSuffix();
            validationExecutorSchematron = PhiveRulesCIIHelper.createXSLT_CII_D16B((IReadableResource)new ClassPathResource("/external/schematron/2.2/FACTUR-X_" + string2 + ".xslt", ZugferdValidation._getCL()));
            dVRCoordinate = PhiveRulesHelper.createCoordinate((String)GROUP_ID_ZUGFERD, (String)eZugferdProfile.getArtifactID(), (String)"2.2");
            string = "ZUGFeRD 2.2 (" + eZugferdProfile.getDisplayName() + ")";
            iValidationExecutorSetStatus = PhiveRulesHelper.createSimpleStatus((boolean)false);
            validationExecutorSet = eZugferdProfile == EZugferdProfile.EN16931 ? ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSetRegistry.getOfID(EN16931Validation.VID_CII_137), (DVRCoordinate)dVRCoordinate, (String)string, (IValidationExecutorSetStatus)iValidationExecutorSetStatus, (IValidationExecutor[])new IValidationExecutor[]{validationExecutorSchematron}) : ValidationExecutorSet.create((DVRCoordinate)dVRCoordinate, (String)string, (IValidationExecutorSetStatus)iValidationExecutorSetStatus, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)new ClassPathResource("/external/schemas/2.2/" + eZugferdProfile.getFolderName() + "/FACTUR-X_" + string2 + ".xsd", ZugferdValidation._getCL())), validationExecutorSchematron});
            iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)validationExecutorSet);
            ZugferdValidation._registerFacturXAlias(iValidationExecutorSetRegistry, eZugferdProfile, (ValidationExecutorSet<IValidationSourceXML>)validationExecutorSet);
        }
        for (EZugferdProfile eZugferdProfile : EZugferdProfile.values()) {
            string2 = ValidationExecutorSet.create((DVRCoordinate)PhiveRulesHelper.createCoordinate((String)GROUP_ID_ZUGFERD, (String)eZugferdProfile.getArtifactID(), (String)"2.3.2"), (String)("ZUGFeRD 2.3.2 (" + eZugferdProfile.getDisplayName() + ")"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)new ClassPathResource("/external/schemas/2.3.2/" + eZugferdProfile.getFolderName() + "/Factur-X_1.07.2_" + eZugferdProfile.getFilenameSuffix() + ".xsd", ZugferdValidation._getCL())), PhiveRulesCIIHelper.createXSLT_CII_D22B((IReadableResource)new ClassPathResource("/external/schematron/2.3.2/Factur-X_1.07.2_" + eZugferdProfile.getFilenameSuffix() + ".xslt", ZugferdValidation._getCL()))});
            iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)string2);
            ZugferdValidation._registerFacturXAlias(iValidationExecutorSetRegistry, eZugferdProfile, (ValidationExecutorSet<IValidationSourceXML>)string2);
        }
    }

    static {
        ZUGFERD_TO_FACTURX_MAP.put((Object)DVRVersion.parseOrNull((String)"2.0.1"), (Object)DVRVersion.parseOrNull((String)"1.0.3"));
        ZUGFERD_TO_FACTURX_MAP.put((Object)DVRVersion.parseOrNull((String)"2.1"), (Object)DVRVersion.parseOrNull((String)"1.0.5"));
        ZUGFERD_TO_FACTURX_MAP.put((Object)DVRVersion.parseOrNull((String)"2.2"), (Object)DVRVersion.parseOrNull((String)"1.0.6"));
        ZUGFERD_TO_FACTURX_MAP.put((Object)DVRVersion.parseOrNull((String)"2.3.2"), (Object)DVRVersion.parseOrNull((String)"1.0.7-2"));
    }
}

