/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IHasJson;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.pd.businesscard.generic.PDBusinessEntity;
import com.helger.pd.businesscard.generic.PDIdentifier;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PDBusinessCard
implements IHasJson,
Serializable,
ICloneable<PDBusinessCard> {
    private PDIdentifier m_aParticipantIdentifier;
    private final ICommonsList<PDBusinessEntity> m_aBusinessEntities = new CommonsArrayList();

    public PDBusinessCard() {
    }

    public PDBusinessCard(@Nullable PDIdentifier pDIdentifier, @Nullable ICommonsList<PDBusinessEntity> iCommonsList) {
        this.setParticipantIdentifier(pDIdentifier);
        this.businessEntities().setAll(iCommonsList);
    }

    @Nullable
    public final PDIdentifier getParticipantIdentifier() {
        return this.m_aParticipantIdentifier;
    }

    @Nonnull
    public final PDBusinessCard setParticipantIdentifier(@Nullable PDIdentifier pDIdentifier) {
        this.m_aParticipantIdentifier = pDIdentifier;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PDBusinessEntity> businessEntities() {
        return this.m_aBusinessEntities;
    }

    public void cloneTo(@Nonnull PDBusinessCard pDBusinessCard) {
        pDBusinessCard.m_aParticipantIdentifier = this.m_aParticipantIdentifier;
        pDBusinessCard.m_aBusinessEntities.setAllMapped(this.m_aBusinessEntities, PDBusinessEntity::getClone);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PDBusinessCard getClone() {
        PDBusinessCard pDBusinessCard = new PDBusinessCard();
        this.cloneTo(pDBusinessCard);
        return pDBusinessCard;
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.appendChild((IMicroNode)this.m_aParticipantIdentifier.getAsMicroXML(string, "participant"));
        for (PDBusinessEntity pDBusinessEntity : this.m_aBusinessEntities) {
            microElement.appendChild((IMicroNode)pDBusinessEntity.getAsMicroXML(string, "entity"));
        }
        return microElement;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addJson("participant", (IJson)this.m_aParticipantIdentifier.getAsJson());
        jsonObject.addJson("entity", (IJson)new JsonArray().addAllMapped(this.m_aBusinessEntities, PDBusinessEntity::getAsJson));
        return jsonObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDBusinessCard pDBusinessCard = (PDBusinessCard)object;
        return EqualsHelper.equals((Object)this.m_aParticipantIdentifier, (Object)pDBusinessCard.m_aParticipantIdentifier) && EqualsHelper.equals(this.m_aBusinessEntities, pDBusinessCard.m_aBusinessEntities);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aParticipantIdentifier).append(this.m_aBusinessEntities).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ParticipantIdentifier", (Object)this.m_aParticipantIdentifier).append("Entities", this.m_aBusinessEntities).getToString();
    }

    @Nonnull
    public static PDBusinessCard of(@Nonnull IJsonObject iJsonObject) {
        PDIdentifier pDIdentifier = PDIdentifier.of(iJsonObject.getAsObject("participant"));
        CommonsArrayList commonsArrayList = CommonsArrayList.createFiltered((Iterable)iJsonObject.getAsArray("entity"), IJson::isObject, iJson -> PDBusinessEntity.of(iJson.getAsObject()));
        return new PDBusinessCard(pDIdentifier, (ICommonsList<PDBusinessEntity>)commonsArrayList);
    }
}

