/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IHasJson;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.pd.businesscard.generic.PDContact;
import com.helger.pd.businesscard.generic.PDIdentifier;
import com.helger.pd.businesscard.generic.PDName;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PDBusinessEntity
implements IHasJson,
Serializable,
ICloneable<PDBusinessEntity> {
    private final ICommonsList<PDName> m_aNames = new CommonsArrayList();
    private String m_sCountryCode;
    private String m_sGeoInfo;
    private final ICommonsList<PDIdentifier> m_aIDs = new CommonsArrayList();
    private final ICommonsList<String> m_aWebsiteURIs = new CommonsArrayList();
    private final ICommonsList<PDContact> m_aContacts = new CommonsArrayList();
    private String m_sAdditionalInfo;
    private LocalDate m_aRegistrationDate;

    public PDBusinessEntity() {
    }

    public PDBusinessEntity(@Nullable ICommonsList<PDName> iCommonsList, @Nullable String string, @Nullable String string2, @Nullable ICommonsList<PDIdentifier> iCommonsList2, @Nullable ICommonsList<String> iCommonsList3, @Nullable ICommonsList<PDContact> iCommonsList4, @Nullable String string3, @Nullable LocalDate localDate) {
        this.names().setAll(iCommonsList);
        this.setCountryCode(string);
        this.setGeoInfo(string2);
        this.identifiers().setAll(iCommonsList2);
        this.websiteURIs().setAll(iCommonsList3);
        this.contacts().setAllMapped(iCommonsList4, PDContact::getClone);
        this.setAdditionalInfo(string3);
        this.setRegistrationDate(localDate);
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PDName> names() {
        return this.m_aNames;
    }

    @Nullable
    public final String getCountryCode() {
        return this.m_sCountryCode;
    }

    public final boolean hasCountryCode() {
        return StringHelper.hasText((String)this.m_sCountryCode);
    }

    @Nonnull
    public final PDBusinessEntity setCountryCode(@Nullable String string) {
        this.m_sCountryCode = string;
        return this;
    }

    @Nullable
    public final String getGeoInfo() {
        return this.m_sGeoInfo;
    }

    public final boolean hasGeoInfo() {
        return StringHelper.hasText((String)this.m_sGeoInfo);
    }

    @Nonnull
    public final PDBusinessEntity setGeoInfo(@Nullable String string) {
        this.m_sGeoInfo = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PDIdentifier> identifiers() {
        return this.m_aIDs;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<String> websiteURIs() {
        return this.m_aWebsiteURIs;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PDContact> contacts() {
        return this.m_aContacts;
    }

    @Nullable
    public final String getAdditionalInfo() {
        return this.m_sAdditionalInfo;
    }

    public final boolean hasAdditionalInfo() {
        return StringHelper.hasText((String)this.m_sAdditionalInfo);
    }

    @Nonnull
    public final PDBusinessEntity setAdditionalInfo(@Nullable String string) {
        this.m_sAdditionalInfo = string;
        return this;
    }

    @Nullable
    public final LocalDate getRegistrationDate() {
        return this.m_aRegistrationDate;
    }

    public final boolean hasRegistrationDate() {
        return this.m_aRegistrationDate != null;
    }

    @Nonnull
    public final PDBusinessEntity setRegistrationDate(@Nullable LocalDate localDate) {
        this.m_aRegistrationDate = localDate;
        return this;
    }

    public void cloneTo(@Nonnull PDBusinessEntity pDBusinessEntity) {
        pDBusinessEntity.m_aNames.setAllMapped(this.m_aNames, PDName::getClone);
        pDBusinessEntity.m_sCountryCode = this.m_sCountryCode;
        pDBusinessEntity.m_sGeoInfo = this.m_sGeoInfo;
        pDBusinessEntity.m_aIDs.setAllMapped(this.m_aIDs, PDIdentifier::getClone);
        pDBusinessEntity.m_aWebsiteURIs.setAll(this.m_aWebsiteURIs);
        pDBusinessEntity.m_aContacts.setAllMapped(this.m_aContacts, PDContact::getClone);
        pDBusinessEntity.m_sAdditionalInfo = this.m_sAdditionalInfo;
        pDBusinessEntity.m_aRegistrationDate = this.m_aRegistrationDate;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PDBusinessEntity getClone() {
        PDBusinessEntity pDBusinessEntity = new PDBusinessEntity();
        this.cloneTo(pDBusinessEntity);
        return pDBusinessEntity;
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        for (Object object : this.m_aNames) {
            microElement.appendChild((IMicroNode)((PDName)object).getAsMicroXML(string, "name"));
        }
        microElement.setAttribute("countrycode", this.m_sCountryCode);
        if (this.hasGeoInfo()) {
            microElement.appendElement(string, "geoinfo").appendText((CharSequence)this.m_sGeoInfo);
        }
        for (Object object : this.m_aIDs) {
            microElement.appendChild((IMicroNode)((PDIdentifier)object).getAsMicroXML(string, "id"));
        }
        for (Object object : this.m_aWebsiteURIs) {
            microElement.appendElement(string, "website").appendText((CharSequence)object);
        }
        for (Object object : this.m_aContacts) {
            microElement.appendChild((IMicroNode)((PDContact)object).getAsMicroXML(string, "contact"));
        }
        if (this.hasAdditionalInfo()) {
            microElement.appendElement(string, "additionalinfo").appendText((CharSequence)this.m_sAdditionalInfo);
        }
        if (this.hasRegistrationDate()) {
            microElement.appendElement(string, "regdate").appendText((CharSequence)PDTWebDateHelper.getAsStringXSD((LocalDate)this.m_aRegistrationDate));
        }
        return microElement;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addJson("name", (IJson)new JsonArray().addAllMapped(this.m_aNames, PDName::getAsJson));
        jsonObject.add("countrycode", (Object)this.m_sCountryCode);
        if (this.hasGeoInfo()) {
            jsonObject.add("geoinfo", (Object)this.m_sGeoInfo);
        }
        if (this.m_aIDs.isNotEmpty()) {
            jsonObject.addJson("id", (IJson)new JsonArray().addAllMapped(this.m_aIDs, PDIdentifier::getAsJson));
        }
        if (this.m_aWebsiteURIs.isNotEmpty()) {
            jsonObject.addJson("website", (IJson)new JsonArray().addAll(this.m_aWebsiteURIs));
        }
        if (this.m_aContacts.isNotEmpty()) {
            jsonObject.addJson("contact", (IJson)new JsonArray().addAllMapped(this.m_aContacts, PDContact::getAsJson));
        }
        if (this.hasAdditionalInfo()) {
            jsonObject.add("additionalinfo", (Object)this.m_sAdditionalInfo);
        }
        if (this.hasRegistrationDate()) {
            jsonObject.add("regdate", (Object)PDTWebDateHelper.getAsStringXSD((LocalDate)this.m_aRegistrationDate));
        }
        return jsonObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDBusinessEntity pDBusinessEntity = (PDBusinessEntity)object;
        return EqualsHelper.equals(this.m_aNames, pDBusinessEntity.m_aNames) && EqualsHelper.equals((Object)this.m_sCountryCode, (Object)pDBusinessEntity.m_sCountryCode) && EqualsHelper.equals((Object)this.m_sGeoInfo, (Object)pDBusinessEntity.m_sGeoInfo) && EqualsHelper.equals(this.m_aIDs, pDBusinessEntity.m_aIDs) && EqualsHelper.equals(this.m_aWebsiteURIs, pDBusinessEntity.m_aWebsiteURIs) && EqualsHelper.equals(this.m_aContacts, pDBusinessEntity.m_aContacts) && EqualsHelper.equals((Object)this.m_sAdditionalInfo, (Object)pDBusinessEntity.m_sAdditionalInfo) && EqualsHelper.equals((Object)this.m_aRegistrationDate, (Object)pDBusinessEntity.m_aRegistrationDate);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aNames).append((Object)this.m_sCountryCode).append((Object)this.m_sGeoInfo).append(this.m_aIDs).append(this.m_aWebsiteURIs).append(this.m_aContacts).append((Object)this.m_sAdditionalInfo).append((Object)this.m_aRegistrationDate).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("names", this.m_aNames).append("countryCode", (Object)this.m_sCountryCode).append("geographicalInformation", (Object)this.m_sGeoInfo).append("identifier", this.m_aIDs).append("websiteURI", this.m_aWebsiteURIs).append("contact", this.m_aContacts).append("additionalInformation", (Object)this.m_sAdditionalInfo).append("registrationDate", (Object)this.m_aRegistrationDate).getToString();
    }

    @Nullable
    public static PDBusinessEntity of(@Nullable IJsonObject iJsonObject) {
        if (iJsonObject == null) {
            return null;
        }
        CommonsArrayList commonsArrayList = CommonsArrayList.createFiltered((Iterable)iJsonObject.getAsArray("name"), IJson::isObject, iJson -> PDName.of(iJson.getAsObject()));
        CommonsArrayList commonsArrayList2 = CommonsArrayList.createFiltered((Iterable)iJsonObject.getAsArray("id"), IJson::isObject, iJson -> PDIdentifier.of(iJson.getAsObject()));
        CommonsArrayList commonsArrayList3 = CommonsArrayList.createFiltered((Iterable)iJsonObject.getAsArray("website"), IJson::isValue, iJson -> iJson.getAsValue().getAsString());
        CommonsArrayList commonsArrayList4 = CommonsArrayList.createFiltered((Iterable)iJsonObject.getAsArray("contact"), IJson::isObject, iJson -> PDContact.of(iJson.getAsObject()));
        return new PDBusinessEntity((ICommonsList<PDName>)commonsArrayList, iJsonObject.getAsString((Object)"countrycode"), iJsonObject.getAsString((Object)"geoinfo"), (ICommonsList<PDIdentifier>)commonsArrayList2, (ICommonsList<String>)commonsArrayList3, (ICommonsList<PDContact>)commonsArrayList4, iJsonObject.getAsString((Object)"additionalinfo"), PDTWebDateHelper.getLocalDateFromXSD((String)iJsonObject.getAsString((Object)"regdate")));
    }
}

