/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IHasJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PDIdentifier
implements IHasJson,
Serializable,
ICloneable<PDIdentifier> {
    private String m_sScheme;
    private String m_sValue;

    public PDIdentifier() {
    }

    public PDIdentifier(@Nullable String string, @Nullable String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Nullable
    public final String getScheme() {
        return this.m_sScheme;
    }

    @Nonnull
    public final PDIdentifier setScheme(@Nullable String string) {
        this.m_sScheme = string;
        return this;
    }

    @Nullable
    public final String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public final PDIdentifier setValue(@Nullable String string) {
        this.m_sValue = string;
        return this;
    }

    public void cloneTo(@Nonnull PDIdentifier pDIdentifier) {
        pDIdentifier.m_sScheme = this.m_sScheme;
        pDIdentifier.m_sValue = this.m_sValue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PDIdentifier getClone() {
        PDIdentifier pDIdentifier = new PDIdentifier();
        this.cloneTo(pDIdentifier);
        return pDIdentifier;
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute("scheme", this.m_sScheme);
        microElement.setAttribute("value", this.m_sValue);
        return microElement;
    }

    @Nonnull
    public static IJsonObject getAsJson(@Nullable String string, @Nullable String string2) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("scheme", (Object)string);
        jsonObject.add("value", (Object)string2);
        return jsonObject;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        return PDIdentifier.getAsJson(this.m_sScheme, this.m_sValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDIdentifier pDIdentifier = (PDIdentifier)object;
        return EqualsHelper.equals((Object)this.m_sScheme, (Object)pDIdentifier.m_sScheme) && EqualsHelper.equals((Object)this.m_sValue, (Object)pDIdentifier.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sScheme).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Scheme", (Object)this.m_sScheme).append("Value", (Object)this.m_sValue).getToString();
    }

    @Nullable
    public static PDIdentifier of(@Nullable IJsonObject iJsonObject) {
        return iJsonObject == null ? null : new PDIdentifier(iJsonObject.getAsString((Object)"scheme"), iJsonObject.getAsString((Object)"value"));
    }
}

