/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.locale.language.LanguageCache;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IHasJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PDName
implements IHasJson,
Serializable,
ICloneable<PDName> {
    private String m_sName;
    private String m_sLanguageCode;

    public static boolean isValidLanguageCode(@Nullable String string) {
        return string == null || string.length() == 2 && LanguageCache.getInstance().containsLanguage(string);
    }

    public PDName() {
    }

    public PDName(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public PDName(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.setName(string);
        ValueEnforcer.isTrue((boolean)PDName.isValidLanguageCode(string2), () -> "'" + string2 + "' is invalid language code");
        this.m_sLanguageCode = LocaleHelper.getValidLanguageCode((String)string2);
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final PDName setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        this.m_sName = string;
        return this;
    }

    @Nullable
    public final String getLanguageCode() {
        return this.m_sLanguageCode;
    }

    public final boolean hasNoLanguageCode() {
        return StringHelper.hasNoText((String)this.m_sLanguageCode);
    }

    @Nonnull
    public final PDName setLanguageCode(@Nullable String string) {
        ValueEnforcer.isTrue((boolean)PDName.isValidLanguageCode(string), () -> "'" + string + "' is invalid language code");
        this.m_sLanguageCode = LocaleHelper.getValidLanguageCode((String)string);
        return this;
    }

    public void cloneTo(@Nonnull PDName pDName) {
        pDName.m_sName = this.m_sName;
        pDName.m_sLanguageCode = this.m_sLanguageCode;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PDName getClone() {
        PDName pDName = new PDName();
        this.cloneTo(pDName);
        return pDName;
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute("name", this.m_sName);
        microElement.setAttribute("language", this.m_sLanguageCode);
        return microElement;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("name", (Object)this.m_sName);
        if (this.m_sLanguageCode != null) {
            jsonObject.add("language", (Object)this.m_sLanguageCode);
        }
        return jsonObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDName pDName = (PDName)object;
        return this.m_sName.equals(pDName.m_sName) && EqualsHelper.equals((Object)this.m_sLanguageCode, (Object)pDName.m_sLanguageCode);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_sLanguageCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Name", (Object)this.m_sName).appendIfNotNull("LanguageCode", (Object)this.m_sLanguageCode).getToString();
    }

    @Nullable
    public static PDName of(@Nullable IJsonObject iJsonObject) {
        return iJsonObject == null ? null : new PDName(iJsonObject.getAsString((Object)"name"), iJsonObject.getAsString((Object)"language"));
    }
}

