/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.helper;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.jaxb.GenericJAXBMarshaller;
import com.helger.pd.businesscard.generic.PDBusinessCard;
import com.helger.pd.businesscard.v1.PD1APIHelper;
import com.helger.pd.businesscard.v1.PD1BusinessCardMarshaller;
import com.helger.pd.businesscard.v1.PD1BusinessCardType;
import com.helger.pd.businesscard.v2.PD2APIHelper;
import com.helger.pd.businesscard.v2.PD2BusinessCardMarshaller;
import com.helger.pd.businesscard.v2.PD2BusinessCardType;
import com.helger.pd.businesscard.v3.PD3APIHelper;
import com.helger.pd.businesscard.v3.PD3BusinessCardMarshaller;
import com.helger.pd.businesscard.v3.PD3BusinessCardType;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Node;

@Immutable
public final class PDBusinessCardHelper {
    private PDBusinessCardHelper() {
    }

    @Nullable
    public static PDBusinessCard parseBusinessCard(@Nonnull byte[] byArray, @Nullable Charset charset) {
        ValueEnforcer.notNull((Object)byArray, (String)"Data");
        return PDBusinessCardHelper.parseBusinessCard(byArray, (? super GenericJAXBMarshaller<?> genericJAXBMarshaller) -> {
            genericJAXBMarshaller.readExceptionCallbacks().removeAll();
            if (charset != null) {
                genericJAXBMarshaller.setCharset(charset);
            }
        });
    }

    @Nullable
    public static PDBusinessCard parseBusinessCard(@Nonnull byte[] byArray, @Nullable Consumer<? super GenericJAXBMarshaller<?>> consumer) {
        IExplicitlyCloneable iExplicitlyCloneable;
        ValueEnforcer.notNull((Object)byArray, (String)"Data");
        GenericJAXBMarshaller genericJAXBMarshaller = new PD1BusinessCardMarshaller();
        if (consumer != null) {
            consumer.accept(genericJAXBMarshaller);
        }
        if ((iExplicitlyCloneable = (PD1BusinessCardType)genericJAXBMarshaller.read(byArray)) != null) {
            try {
                return PD1APIHelper.createBusinessCard(iExplicitlyCloneable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        genericJAXBMarshaller = new PD2BusinessCardMarshaller();
        if (consumer != null) {
            consumer.accept(genericJAXBMarshaller);
        }
        if ((iExplicitlyCloneable = (PD2BusinessCardType)genericJAXBMarshaller.read(byArray)) != null) {
            try {
                return PD2APIHelper.createBusinessCard((PD2BusinessCardType)iExplicitlyCloneable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        genericJAXBMarshaller = new PD3BusinessCardMarshaller();
        if (consumer != null) {
            consumer.accept(genericJAXBMarshaller);
        }
        if ((iExplicitlyCloneable = (PD3BusinessCardType)genericJAXBMarshaller.read(byArray)) != null) {
            try {
                return PD3APIHelper.createBusinessCard((PD3BusinessCardType)iExplicitlyCloneable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static PDBusinessCard parseBusinessCard(@Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return PDBusinessCardHelper.parseBusinessCard(node, (? super GenericJAXBMarshaller<?> genericJAXBMarshaller) -> genericJAXBMarshaller.readExceptionCallbacks().removeAll());
    }

    @Nullable
    public static PDBusinessCard parseBusinessCard(@Nonnull Node node, @Nullable Consumer<? super GenericJAXBMarshaller<?>> consumer) {
        IExplicitlyCloneable iExplicitlyCloneable;
        ValueEnforcer.notNull((Object)node, (String)"Node");
        GenericJAXBMarshaller genericJAXBMarshaller = new PD1BusinessCardMarshaller();
        if (consumer != null) {
            consumer.accept(genericJAXBMarshaller);
        }
        if ((iExplicitlyCloneable = (PD1BusinessCardType)genericJAXBMarshaller.read(node)) != null) {
            try {
                return PD1APIHelper.createBusinessCard(iExplicitlyCloneable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        genericJAXBMarshaller = new PD2BusinessCardMarshaller();
        if (consumer != null) {
            consumer.accept(genericJAXBMarshaller);
        }
        if ((iExplicitlyCloneable = (PD2BusinessCardType)genericJAXBMarshaller.read(node)) != null) {
            try {
                return PD2APIHelper.createBusinessCard((PD2BusinessCardType)iExplicitlyCloneable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        genericJAXBMarshaller = new PD3BusinessCardMarshaller();
        if (consumer != null) {
            consumer.accept(genericJAXBMarshaller);
        }
        if ((iExplicitlyCloneable = (PD3BusinessCardType)genericJAXBMarshaller.read(node)) != null) {
            try {
                return PD3APIHelper.createBusinessCard((PD3BusinessCardType)iExplicitlyCloneable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }
}

