/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v1;

import com.helger.commons.ValueEnforcer;
import com.helger.pd.businesscard.generic.PDBusinessCard;
import com.helger.pd.businesscard.generic.PDBusinessEntity;
import com.helger.pd.businesscard.generic.PDContact;
import com.helger.pd.businesscard.generic.PDIdentifier;
import com.helger.pd.businesscard.generic.PDName;
import com.helger.pd.businesscard.v1.PD1BusinessCardType;
import com.helger.pd.businesscard.v1.PD1BusinessEntityType;
import com.helger.pd.businesscard.v1.PD1ContactType;
import com.helger.pd.businesscard.v1.PD1IdentifierType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PD1APIHelper {
    private PD1APIHelper() {
    }

    @Nonnull
    public static PD1IdentifierType createIdentifier(@Nullable String string, @Nullable String string2) {
        PD1IdentifierType pD1IdentifierType = new PD1IdentifierType();
        pD1IdentifierType.setScheme(string);
        pD1IdentifierType.setValue(string2);
        return pD1IdentifierType;
    }

    @Nullable
    public static PDIdentifier createIdentifier(@Nonnull PD1IdentifierType pD1IdentifierType) {
        ValueEnforcer.notNull((Object)pD1IdentifierType, (String)"ID");
        return new PDIdentifier(pD1IdentifierType.getScheme(), pD1IdentifierType.getValue());
    }

    @Nonnull
    public static PD1ContactType createContact(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        PD1ContactType pD1ContactType = new PD1ContactType();
        pD1ContactType.setType(string);
        pD1ContactType.setName(string2);
        pD1ContactType.setPhoneNumber(string3);
        pD1ContactType.setEmail(string4);
        return pD1ContactType;
    }

    @Nonnull
    public static PDContact createContact(@Nonnull PD1ContactType pD1ContactType) {
        ValueEnforcer.notNull((Object)pD1ContactType, (String)"Contact");
        return new PDContact(pD1ContactType.getType(), pD1ContactType.getName(), pD1ContactType.getPhoneNumber(), pD1ContactType.getEmail());
    }

    @Nonnull
    public static PDBusinessEntity createBusinessEntity(@Nonnull PD1BusinessEntityType pD1BusinessEntityType) {
        ValueEnforcer.notNull((Object)pD1BusinessEntityType, (String)"BusinessEntity");
        PDBusinessEntity pDBusinessEntity = new PDBusinessEntity();
        pDBusinessEntity.names().add((Object)new PDName(pD1BusinessEntityType.getName()));
        pDBusinessEntity.setCountryCode(pD1BusinessEntityType.getCountryCode());
        pDBusinessEntity.setGeoInfo(pD1BusinessEntityType.getGeographicalInformation());
        pDBusinessEntity.identifiers().setAllMapped(pD1BusinessEntityType.getIdentifier(), PD1APIHelper::createIdentifier);
        pDBusinessEntity.websiteURIs().setAll(pD1BusinessEntityType.getWebsiteURI());
        pDBusinessEntity.contacts().setAllMapped(pD1BusinessEntityType.getContact(), PD1APIHelper::createContact);
        pDBusinessEntity.setAdditionalInfo(pD1BusinessEntityType.getAdditionalInformation());
        pDBusinessEntity.setRegistrationDate(pD1BusinessEntityType.getRegistrationDate());
        return pDBusinessEntity;
    }

    @Nonnull
    public static PDBusinessCard createBusinessCard(@Nonnull PD1BusinessCardType pD1BusinessCardType) {
        ValueEnforcer.notNull((Object)pD1BusinessCardType, (String)"BusinessCard");
        PDBusinessCard pDBusinessCard = new PDBusinessCard();
        pDBusinessCard.setParticipantIdentifier(PD1APIHelper.createIdentifier(pD1BusinessCardType.getParticipantIdentifier()));
        pDBusinessCard.businessEntities().setAllMapped(pD1BusinessCardType.getBusinessEntity(), PD1APIHelper::createBusinessEntity);
        return pDBusinessCard;
    }
}

