/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v2;

import com.helger.commons.ValueEnforcer;
import com.helger.pd.businesscard.generic.PDBusinessCard;
import com.helger.pd.businesscard.generic.PDBusinessEntity;
import com.helger.pd.businesscard.generic.PDIdentifier;
import com.helger.pd.businesscard.generic.PDName;
import com.helger.pd.businesscard.v2.PD2BusinessCardType;
import com.helger.pd.businesscard.v2.PD2BusinessEntityType;
import com.helger.pd.businesscard.v2.PD2IdentifierType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PD2APIHelper {
    private PD2APIHelper() {
    }

    @Nonnull
    public static PD2IdentifierType createIdentifier(@Nullable String string, @Nullable String string2) {
        PD2IdentifierType pD2IdentifierType = new PD2IdentifierType();
        pD2IdentifierType.setScheme(string);
        pD2IdentifierType.setValue(string2);
        return pD2IdentifierType;
    }

    @Nullable
    public static PDIdentifier createIdentifier(@Nonnull PD2IdentifierType pD2IdentifierType) {
        ValueEnforcer.notNull((Object)pD2IdentifierType, (String)"ID");
        return new PDIdentifier(pD2IdentifierType.getScheme(), pD2IdentifierType.getValue());
    }

    @Nonnull
    public static PDBusinessEntity createBusinessEntity(@Nonnull PD2BusinessEntityType pD2BusinessEntityType) {
        ValueEnforcer.notNull((Object)pD2BusinessEntityType, (String)"BusinessEntity");
        PDBusinessEntity pDBusinessEntity = new PDBusinessEntity();
        pDBusinessEntity.names().add((Object)new PDName(pD2BusinessEntityType.getName()));
        pDBusinessEntity.setCountryCode(pD2BusinessEntityType.getCountryCode());
        pDBusinessEntity.setGeoInfo(pD2BusinessEntityType.getGeographicalInformation());
        pDBusinessEntity.identifiers().setAllMapped(pD2BusinessEntityType.getIdentifier(), PD2APIHelper::createIdentifier);
        pDBusinessEntity.setRegistrationDate(pD2BusinessEntityType.getRegistrationDate());
        return pDBusinessEntity;
    }

    @Nonnull
    public static PDBusinessCard createBusinessCard(@Nonnull PD2BusinessCardType pD2BusinessCardType) {
        ValueEnforcer.notNull((Object)pD2BusinessCardType, (String)"BusinessCard");
        PDBusinessCard pDBusinessCard = new PDBusinessCard();
        pDBusinessCard.setParticipantIdentifier(PD2APIHelper.createIdentifier(pD2BusinessCardType.getParticipantIdentifier()));
        pDBusinessCard.businessEntities().setAllMapped(pD2BusinessCardType.getBusinessEntity(), PD2APIHelper::createBusinessEntity);
        return pDBusinessCard;
    }
}

