/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v3;

import com.helger.commons.ValueEnforcer;
import com.helger.pd.businesscard.generic.PDBusinessCard;
import com.helger.pd.businesscard.generic.PDBusinessEntity;
import com.helger.pd.businesscard.generic.PDContact;
import com.helger.pd.businesscard.generic.PDIdentifier;
import com.helger.pd.businesscard.generic.PDName;
import com.helger.pd.businesscard.v3.PD3BusinessCardType;
import com.helger.pd.businesscard.v3.PD3BusinessEntityType;
import com.helger.pd.businesscard.v3.PD3ContactType;
import com.helger.pd.businesscard.v3.PD3IdentifierType;
import com.helger.pd.businesscard.v3.PD3MultilingualNameType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PD3APIHelper {
    private PD3APIHelper() {
    }

    @Nonnull
    public static PD3IdentifierType createIdentifier(@Nullable String string, @Nullable String string2) {
        PD3IdentifierType pD3IdentifierType = new PD3IdentifierType();
        pD3IdentifierType.setScheme(string);
        pD3IdentifierType.setValue(string2);
        return pD3IdentifierType;
    }

    @Nullable
    public static PDIdentifier createIdentifier(@Nonnull PD3IdentifierType pD3IdentifierType) {
        ValueEnforcer.notNull((Object)pD3IdentifierType, (String)"ID");
        return new PDIdentifier(pD3IdentifierType.getScheme(), pD3IdentifierType.getValue());
    }

    @Nonnull
    public static PD3ContactType createContact(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        PD3ContactType pD3ContactType = new PD3ContactType();
        pD3ContactType.setType(string);
        pD3ContactType.setName(string2);
        pD3ContactType.setPhoneNumber(string3);
        pD3ContactType.setEmail(string4);
        return pD3ContactType;
    }

    @Nonnull
    public static PDContact createContact(@Nonnull PD3ContactType pD3ContactType) {
        ValueEnforcer.notNull((Object)pD3ContactType, (String)"Contact");
        return new PDContact(pD3ContactType.getType(), pD3ContactType.getName(), pD3ContactType.getPhoneNumber(), pD3ContactType.getEmail());
    }

    @Nonnull
    public static PD3MultilingualNameType createName(@Nullable String string, @Nullable String string2) {
        PD3MultilingualNameType pD3MultilingualNameType = new PD3MultilingualNameType();
        pD3MultilingualNameType.setValue(string);
        pD3MultilingualNameType.setLanguage(string2);
        return pD3MultilingualNameType;
    }

    @Nonnull
    public static PDName createName(@Nonnull PD3MultilingualNameType pD3MultilingualNameType) {
        ValueEnforcer.notNull((Object)pD3MultilingualNameType, (String)"Name");
        return new PDName(pD3MultilingualNameType.getValue(), pD3MultilingualNameType.getLanguage());
    }

    @Nonnull
    public static PDBusinessEntity createBusinessEntity(@Nonnull PD3BusinessEntityType pD3BusinessEntityType) {
        ValueEnforcer.notNull((Object)pD3BusinessEntityType, (String)"BusinessEntity");
        PDBusinessEntity pDBusinessEntity = new PDBusinessEntity();
        pDBusinessEntity.names().setAllMapped(pD3BusinessEntityType.getName(), PD3APIHelper::createName);
        pDBusinessEntity.setCountryCode(pD3BusinessEntityType.getCountryCode());
        pDBusinessEntity.setGeoInfo(pD3BusinessEntityType.getGeographicalInformation());
        pDBusinessEntity.identifiers().setAllMapped(pD3BusinessEntityType.getIdentifier(), PD3APIHelper::createIdentifier);
        pDBusinessEntity.websiteURIs().setAll(pD3BusinessEntityType.getWebsiteURI());
        pDBusinessEntity.contacts().setAllMapped(pD3BusinessEntityType.getContact(), PD3APIHelper::createContact);
        pDBusinessEntity.setAdditionalInfo(pD3BusinessEntityType.getAdditionalInformation());
        pDBusinessEntity.setRegistrationDate(pD3BusinessEntityType.getRegistrationDate());
        return pDBusinessEntity;
    }

    @Nonnull
    public static PDBusinessCard createBusinessCard(@Nonnull PD3BusinessCardType pD3BusinessCardType) {
        ValueEnforcer.notNull((Object)pD3BusinessCardType, (String)"BusinessCard");
        PDBusinessCard pDBusinessCard = new PDBusinessCard();
        pDBusinessCard.setParticipantIdentifier(PD3APIHelper.createIdentifier(pD3BusinessCardType.getParticipantIdentifier()));
        pDBusinessCard.businessEntities().setAllMapped(pD3BusinessCardType.getBusinessEntity(), PD3APIHelper::createBusinessEntity);
        return pDBusinessCard;
    }
}

