/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.factory.FactoryNewInstance;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.photon.api.IAPIExceptionMapper;
import com.helger.photon.api.IAPIExecutionFilter;
import com.helger.photon.api.IAPIExecutor;
import com.helger.photon.api.pathdescriptor.PathDescriptor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class APIDescriptor
implements IAPIDescriptor {
    private final APIPath m_aAPIPath;
    private final PathDescriptor m_aPathDescriptor;
    private final Supplier<? extends IAPIExecutor> m_aExecutorFactory;
    private final ICommonsOrderedSet<String> m_aRequiredHeaders = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aRequiredParams = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aAllowedMimeTypes = new CommonsLinkedHashSet();
    private IAPIExecutionFilter m_aExecutionFilter;
    private IAPIExceptionMapper m_aExceptionMapper;

    public APIDescriptor(@Nonnull APIPath aPIPath, @Nonnull IAPIExecutor iAPIExecutor) {
        this(aPIPath, () -> iAPIExecutor);
    }

    public APIDescriptor(@Nonnull APIPath aPIPath, @Nonnull Class<? extends IAPIExecutor> clazz) {
        this(aPIPath, (Supplier<? extends IAPIExecutor>)FactoryNewInstance.create(clazz));
    }

    public APIDescriptor(@Nonnull APIPath aPIPath, @Nonnull Supplier<? extends IAPIExecutor> supplier) {
        this.m_aAPIPath = (APIPath)ValueEnforcer.notNull((Object)aPIPath, (String)"Path");
        this.m_aPathDescriptor = PathDescriptor.create(aPIPath.getPath());
        this.m_aExecutorFactory = (Supplier)ValueEnforcer.notNull(supplier, (String)"ExecutorFactory");
    }

    @Override
    @Nonnull
    public final APIPath getAPIPath() {
        return this.m_aAPIPath;
    }

    @Override
    @Nonnull
    public final PathDescriptor getPathDescriptor() {
        return this.m_aPathDescriptor;
    }

    @Override
    @Nonnull
    public final Supplier<? extends IAPIExecutor> getExecutorFactory() {
        return this.m_aExecutorFactory;
    }

    @Nonnull
    public final APIDescriptor addRequiredHeader(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.m_aRequiredHeaders.add((Object)string);
        }
        return this;
    }

    @Nonnull
    public final APIDescriptor addRequiredHeaders(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addRequiredHeader(string);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedSet<String> requiredHeaders() {
        return this.m_aRequiredHeaders;
    }

    @Nonnull
    public final APIDescriptor addRequiredParam(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.m_aRequiredParams.add((Object)string);
        }
        return this;
    }

    @Nonnull
    public final APIDescriptor addRequiredParams(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addRequiredParam(string);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedSet<String> requiredParams() {
        return this.m_aRequiredParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedSet<String> allowedMimeTypes() {
        return this.m_aAllowedMimeTypes;
    }

    @Override
    @Nullable
    public final IAPIExecutionFilter getExecutionFilter() {
        return this.m_aExecutionFilter;
    }

    @Nonnull
    public final APIDescriptor setExecutionFilter(@Nullable IAPIExecutionFilter iAPIExecutionFilter) {
        this.m_aExecutionFilter = iAPIExecutionFilter;
        return this;
    }

    @Override
    @Nullable
    public final IAPIExceptionMapper getExceptionMapper() {
        return this.m_aExceptionMapper;
    }

    @Nonnull
    public final APIDescriptor setExceptionMapper(@Nullable IAPIExceptionMapper iAPIExceptionMapper) {
        this.m_aExceptionMapper = iAPIExceptionMapper;
        return this;
    }

    public String toString() {
        return new ToStringGenerator(null).append("APIPath", (Object)this.m_aAPIPath).append("PathDescriptor", (Object)this.m_aPathDescriptor).append("ExecutionFactory", this.m_aExecutorFactory).appendIf("RequiredHeaders", this.m_aRequiredHeaders, CollectionHelper::isNotEmpty).appendIf("RequiredParams", this.m_aRequiredParams, CollectionHelper::isNotEmpty).appendIf("AllowedMimeTypes", this.m_aAllowedMimeTypes, CollectionHelper::isNotEmpty).appendIfNotNull("ExecutionFilter", (Object)this.m_aExecutionFilter).appendIfNotNull("ExceptionMapper", (Object)this.m_aExceptionMapper).getToString();
    }
}

