/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.api.APIDescriptor;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.photon.api.IAPIPathAmbiguityResolver;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.photon.api.LoggingAPIPathAmbiguityResolver;
import com.helger.photon.api.pathdescriptor.PathDescriptorHelper;
import com.helger.photon.api.pathdescriptor.PathMatchingResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class APIDescriptorList
implements Serializable {
    private final ICommonsMap<EHttpMethod, ICommonsList<APIDescriptor>> m_aMap = new CommonsEnumMap(EHttpMethod.class);

    public APIDescriptorList() {
        for (EHttpMethod eHttpMethod : EHttpMethod.values()) {
            this.m_aMap.put((Object)eHttpMethod, (Object)new CommonsArrayList());
        }
    }

    public void addDescriptor(@Nonnull APIDescriptor aPIDescriptor) {
        ValueEnforcer.notNull((Object)aPIDescriptor, (String)"Descriptor");
        ((ICommonsList)this.m_aMap.get((Object)aPIDescriptor.getHttpMethod())).add((Object)aPIDescriptor);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAPIDescriptor> getAllDescriptors() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (ICommonsList iCommonsList : this.m_aMap.values()) {
            commonsArrayList.addAll((Collection)iCommonsList);
        }
        return commonsArrayList;
    }

    @Nullable
    public InvokableAPIDescriptor getMatching(@Nonnull APIPath aPIPath) {
        return this.getMatching(aPIPath, new LoggingAPIPathAmbiguityResolver());
    }

    @Nullable
    public InvokableAPIDescriptor getMatching(@Nonnull APIPath aPIPath, @Nonnull IAPIPathAmbiguityResolver iAPIPathAmbiguityResolver) {
        ValueEnforcer.notNull((Object)aPIPath, (String)"Path");
        ValueEnforcer.notNull((Object)iAPIPathAmbiguityResolver, (String)"AmbiguityResolver");
        String string = aPIPath.getPath();
        ICommonsList<String> iCommonsList = PathDescriptorHelper.getCleanPathParts(string);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (APIDescriptor aPIDescriptor : (ICommonsList)this.m_aMap.get((Object)aPIPath.getHttpMethod())) {
            PathMatchingResult pathMatchingResult = aPIDescriptor.getPathDescriptor().matchesParts((List<String>)iCommonsList);
            if (!pathMatchingResult.isMatch()) continue;
            commonsArrayList.add((Object)new InvokableAPIDescriptor(aPIDescriptor, string, pathMatchingResult.getAllVariableValues()));
        }
        int n = commonsArrayList.size();
        if (n == 1) {
            return (InvokableAPIDescriptor)commonsArrayList.getFirst();
        }
        return iAPIPathAmbiguityResolver.apply(aPIPath, (ICommonsList<InvokableAPIDescriptor>)commonsArrayList);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }
}

