/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.photon.api.APISettings;
import com.helger.photon.api.IAPIExceptionMapper;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class APIInvoker
implements IAPIInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIInvoker.class);
    private static final IMutableStatisticsHandlerCounter STATS_GLOBAL_INVOKE = StatisticsManager.getCounterHandler((String)(APIInvoker.class.getName() + "$invocations"));
    private static final IMutableStatisticsHandlerKeyedCounter STATS_FUNCTION_INVOKE = StatisticsManager.getKeyedCounterHandler((String)(APIInvoker.class.getName() + "$func"));
    private static final IMutableStatisticsHandlerKeyedTimer STATS_FUNCTION_TIMER = StatisticsManager.getKeyedTimerHandler((String)(APIInvoker.class.getName() + "$timer"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(@Nonnull InvokableAPIDescriptor invokableAPIDescriptor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        ValueEnforcer.notNull((Object)invokableAPIDescriptor, (String)"InvokableDescriptor");
        ValueEnforcer.notNull((Object)iRequestWebScopeWithoutResponse, (String)"RequestScope");
        ValueEnforcer.notNull((Object)unifiedResponse, (String)"UnifiedResponse");
        String string = invokableAPIDescriptor.getPath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking API '" + string + "'");
        }
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            STATS_GLOBAL_INVOKE.increment();
            APISettings.beforeExecutionCallbacks().forEach(iAPIBeforeExecutionCallback -> iAPIBeforeExecutionCallback.onBeforeExecution(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse));
            invokableAPIDescriptor.invokeAPI(iRequestWebScopeWithoutResponse, unifiedResponse);
            APISettings.afterExecutionCallbacks().forEach(iAPIAfterExecutionCallback -> iAPIAfterExecutionCallback.onAfterExecution(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse));
            STATS_FUNCTION_INVOKE.increment(string);
        }
        catch (Exception exception) {
            boolean bl = false;
            IAPIExceptionMapper iAPIExceptionMapper = invokableAPIDescriptor.getAPIDescriptor().getExceptionMapper();
            if (iAPIExceptionMapper != null) {
                bl = iAPIExceptionMapper.applyExceptionOnResponse(invokableAPIDescriptor, iRequestWebScopeWithoutResponse, unifiedResponse, exception).isHandled();
            }
            if (!bl) {
                APISettings.exceptionCallbacks().forEach(iAPIExceptionCallback -> iAPIExceptionCallback.onAPIExecutionException(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse, exception));
                throw exception;
            }
        }
        finally {
            long l = stopWatch.stopAndGetMillis();
            STATS_FUNCTION_TIMER.addTime(string, l);
            long l2 = APISettings.getLongRunningExecutionLimitTime();
            if (l2 > 0L && l > l2) {
                APISettings.longRunningExecutionCallbacks().forEach(iAPILongRunningExecutionCallback -> iAPILongRunningExecutionCallback.onLongRunningExecution(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse, l));
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)super.toString()).getToString();
    }
}

