/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.photon.api.IAPIAfterExecutionCallback;
import com.helger.photon.api.IAPIBeforeExecutionCallback;
import com.helger.photon.api.IAPIExceptionCallback;
import com.helger.photon.api.IAPILongRunningExecutionCallback;
import com.helger.photon.api.callback.LoggingAPIExceptionCallback;
import com.helger.photon.api.callback.LoggingAPILongRunningExecutionCallback;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class APISettings {
    public static final long DEFAULT_LONG_RUNNING_EXECUTION_LIMIT_MS = 1000L;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final CallbackList<IAPIExceptionCallback> EXCEPTION_CALLBACKS = new CallbackList();
    private static final CallbackList<IAPIBeforeExecutionCallback> BEFORE_EXECUTION_CALLBACKS = new CallbackList();
    private static final CallbackList<IAPIAfterExecutionCallback> AFTER_EXECUTION_CALLBACKS = new CallbackList();
    @GuardedBy(value="RW_LOCK")
    private static long s_nLongRunningExecutionLimitTime = 1000L;
    private static final CallbackList<IAPILongRunningExecutionCallback> LONG_RUNNING_EXECUTION_CALLBACKS = new CallbackList();

    private APISettings() {
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public static CallbackList<IAPIExceptionCallback> exceptionCallbacks() {
        return EXCEPTION_CALLBACKS;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public static CallbackList<IAPIBeforeExecutionCallback> beforeExecutionCallbacks() {
        return BEFORE_EXECUTION_CALLBACKS;
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IAPIAfterExecutionCallback> afterExecutionCallbacks() {
        return AFTER_EXECUTION_CALLBACKS;
    }

    @CheckForSigned
    public static long getLongRunningExecutionLimitTime() {
        return RW_LOCK.readLockedLong(() -> s_nLongRunningExecutionLimitTime);
    }

    public static void setLongRunningExecutionLimitTime(long l) {
        RW_LOCK.writeLocked(() -> {
            s_nLongRunningExecutionLimitTime = l;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IAPILongRunningExecutionCallback> longRunningExecutionCallbacks() {
        return LONG_RUNNING_EXECUTION_CALLBACKS;
    }

    static {
        APISettings.exceptionCallbacks().add((ICallback)new LoggingAPIExceptionCallback());
        APISettings.longRunningExecutionCallbacks().add((ICallback)new LoggingAPILongRunningExecutionCallback());
    }
}

