/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.pathdescriptor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.URLHelper;
import com.helger.photon.api.pathdescriptor.PathDescriptorHelper;
import com.helger.photon.api.pathdescriptor.PathDescriptorPart;
import com.helger.photon.api.pathdescriptor.PathMatchingResult;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PathDescriptor
implements Serializable {
    private final ICommonsList<PathDescriptorPart> m_aPathParts = new CommonsArrayList();

    private PathDescriptor(@Nonnull @Nonempty List<String> list) {
        ValueEnforcer.notEmpty(list, (String)"PathParts");
        for (String string : list) {
            this.m_aPathParts.add((Object)PathDescriptorPart.create(string));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PathDescriptorPart> getAllParts() {
        return (ICommonsList)this.m_aPathParts.getClone();
    }

    @Nonnull
    public PathMatchingResult matchesParts(@Nonnull List<String> list) {
        ValueEnforcer.notNull(list, (String)"PathParts");
        int n = this.m_aPathParts.size();
        if (list.size() != n) {
            return PathMatchingResult.NO_MATCH;
        }
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (int i = 0; i < n; ++i) {
            String string;
            PathDescriptorPart pathDescriptorPart = (PathDescriptorPart)this.m_aPathParts.get(i);
            if (!pathDescriptorPart.matches(string = list.get(i))) {
                return PathMatchingResult.NO_MATCH;
            }
            if (!pathDescriptorPart.isVariable()) continue;
            commonsLinkedHashMap.put((Object)pathDescriptorPart.getName(), (Object)URLHelper.urlDecodeOrNull((String)string));
        }
        return PathMatchingResult.createSuccess((ICommonsOrderedMap<String, String>)commonsLinkedHashMap);
    }

    @Nonnull
    @Nonempty
    public String getAsURLString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PathDescriptorPart pathDescriptorPart : this.m_aPathParts) {
            stringBuilder.append('/').append(pathDescriptorPart.getAsURLString());
        }
        return stringBuilder.toString();
    }

    public boolean containsVariables() {
        return this.m_aPathParts.containsAny(PathDescriptorPart::isVariable);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PathDescriptor pathDescriptor = (PathDescriptor)object;
        return this.m_aPathParts.equals(pathDescriptor.m_aPathParts);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aPathParts).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("PathParts", this.m_aPathParts).getToString();
    }

    @Nonnull
    public static PathDescriptor create(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ICommonsList<String> iCommonsList = PathDescriptorHelper.getCleanPathParts(string);
        return new PathDescriptor((List<String>)iCommonsList);
    }
}

