/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.state.ESuccess;
import com.helger.commons.type.ObjectType;
import com.helger.photon.audit.AuditItem;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.IAuditActionStringProvider;
import com.helger.photon.audit.IAuditItem;
import com.helger.photon.audit.IAuditor;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractAuditor
implements IAuditor {
    private ICurrentUserIDProvider m_aCurrentUserIDProvider;
    private IAuditActionStringProvider m_aActionStringProvider;

    public AbstractAuditor(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider) {
        this(iCurrentUserIDProvider, IAuditActionStringProvider.JSON);
    }

    protected AbstractAuditor(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider, @Nonnull IAuditActionStringProvider iAuditActionStringProvider) {
        this.setCurrentUserIDProvider(iCurrentUserIDProvider);
        this.setActionStringProvider(iAuditActionStringProvider);
    }

    @Nonnull
    public final ICurrentUserIDProvider getCurrentUserIDProvider() {
        return this.m_aCurrentUserIDProvider;
    }

    public final void setCurrentUserIDProvider(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider) {
        this.m_aCurrentUserIDProvider = (ICurrentUserIDProvider)ValueEnforcer.notNull((Object)iCurrentUserIDProvider, (String)"CurrentUserIDProvider");
    }

    @Nonnull
    public final IAuditActionStringProvider getActionStringProvider() {
        return this.m_aActionStringProvider;
    }

    public final void setActionStringProvider(@Nonnull IAuditActionStringProvider iAuditActionStringProvider) {
        this.m_aActionStringProvider = (IAuditActionStringProvider)ValueEnforcer.notNull((Object)iAuditActionStringProvider, (String)"ActionStringProvider");
    }

    @OverrideOnDemand
    protected abstract void handleAuditItem(@Nonnull IAuditItem var1);

    @Override
    public void createAuditItem(@Nonnull EAuditActionType eAuditActionType, @Nonnull ESuccess eSuccess, @Nullable ObjectType objectType, @Nullable String string, Object ... objectArray) {
        String string2 = (String)this.m_aActionStringProvider.apply(objectType != null ? objectType.getName() : string, objectArray);
        if (string2 != null) {
            AuditItem auditItem = new AuditItem(this.m_aCurrentUserIDProvider.getCurrentUserID(), eAuditActionType, eSuccess, string2);
            this.handleAuditItem(auditItem);
        }
    }
}

