/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IAddableByTrait;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.commons.typeconvert.TypeConverterException;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import java.util.function.BiFunction;

@FunctionalInterface
public interface IAuditActionStringProvider
extends BiFunction<String, Object[], String> {
    public static final IAuditActionStringProvider PLAIN_STRING = (string, objectArray) -> {
        if (ArrayHelper.isEmpty((Object[])objectArray)) {
            return string;
        }
        return string + '(' + StringHelper.getImploded((char)',', (Object[])objectArray) + ')';
    };
    public static final IAuditActionStringProvider JSON = (string, objectArray) -> {
        IJsonArray iJsonArray = (IJsonArray)new JsonArray().addAll(objectArray);
        return new JsonObject().addJson(string, (IJson)iJsonArray).getAsJsonString();
    };
    public static final IAuditActionStringProvider JSON_WITH_CONVERSION = (string, objectArray) -> {
        JsonArray jsonArray = new JsonArray();
        for (Object object : objectArray) {
            IJson iJson = null;
            try {
                iJson = (IJson)TypeConverter.convert((Object)object, IJson.class);
            }
            catch (TypeConverterException typeConverterException) {
                // empty catch block
            }
            if (iJson != null) {
                jsonArray.add((IAddableByTrait)iJson);
                continue;
            }
            jsonArray.add(object);
        }
        return new JsonObject().addJson(string, (IJson)jsonArray).getAsJsonString();
    };
}

