/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.dao.DAOException;
import com.helger.dao.EDAOActionType;
import com.helger.photon.app.dao.AbstractPhotonWALDAO;
import com.helger.photon.audit.AuditItem;
import com.helger.photon.audit.AuditItemList;
import com.helger.photon.audit.AuditManager;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.IAuditActionStringProvider;
import com.helger.photon.audit.IAuditItem;
import com.helger.photon.audit.IAuditor;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SimpleAuditManager
extends AbstractPhotonWALDAO<AuditItem>
implements IAuditor {
    private final ICurrentUserIDProvider m_aCurrentUserIDProvider;
    private final AuditItemList m_aItems = new AuditItemList();

    public SimpleAuditManager(@Nullable String string, @Nonnull ICurrentUserIDProvider iCurrentUserIDProvider) throws DAOException {
        super(AuditItem.class, string);
        this.m_aCurrentUserIDProvider = (ICurrentUserIDProvider)ValueEnforcer.notNull((Object)iCurrentUserIDProvider, (String)"UserIDProvider");
        this.initialRead();
    }

    @IsLocked(value=ELockType.WRITE)
    protected void onRecoveryCreate(@Nonnull AuditItem auditItem) {
        this.m_aItems.internalAddItem(auditItem);
    }

    @IsLocked(value=ELockType.WRITE)
    protected void onRecoveryUpdate(@Nonnull AuditItem auditItem) {
        throw new UnsupportedOperationException();
    }

    @IsLocked(value=ELockType.WRITE)
    protected void onRecoveryDelete(@Nonnull AuditItem auditItem) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        AuditManager.readFromXML(iMicroDocument, this.m_aItems::internalAddItem);
        return EChange.UNCHANGED;
    }

    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("root");
        for (IAuditItem iAuditItem : this.m_aItems.getAllItems()) {
            iMicroElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)iAuditItem, (String)"item"));
        }
        return microDocument;
    }

    @Override
    public void createAuditItem(@Nonnull EAuditActionType eAuditActionType, @Nonnull ESuccess eSuccess, @Nullable ObjectType objectType, @Nullable String string, Object ... objectArray) {
        String string2 = (String)IAuditActionStringProvider.JSON.apply(objectType != null ? objectType.getName() : string, objectArray);
        AuditItem auditItem = new AuditItem(this.m_aCurrentUserIDProvider.getCurrentUserID(), eAuditActionType, eSuccess, string2);
        this.m_aRWLock.writeLocked(() -> {
            this.m_aItems.internalAddItem(auditItem);
            this.markAsChanged(auditItem, EDAOActionType.CREATE);
        });
    }

    @Nonnegative
    public int getAuditItemCount() {
        return this.m_aRWLock.readLockedInt(this.m_aItems::getItemCount);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAuditItem> getAllAuditItems() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(this.m_aItems::getAllItems);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<IAuditItem> getLastAuditItems(@Nonnegative int n) {
        return (List)this.m_aRWLock.readLockedGet(() -> this.m_aItems.getLastItems(n));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SimpleAuditManager simpleAuditManager = (SimpleAuditManager)object;
        return this.m_aItems.equals(simpleAuditManager.m_aItems);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aItems).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("CurrentUserIDProvider", (Object)this.m_aCurrentUserIDProvider).append("Items", (Object)this.m_aItems).getToString();
    }
}

