/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit.v2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.v2.config.AuditSettings;
import com.helger.photon.audit.v2.config.IAuditSettings;
import com.helger.photon.audit.v2.domain.AuditEvent;
import com.helger.photon.audit.v2.domain.AuditField;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AuditEventBuilder {
    private IAuditSettings m_aSettings = AuditSettings.DEFAULT_INSTANCE;
    private ICurrentUserIDProvider m_aCurrentUserIDProvider;
    private String m_sActor;
    private String m_sOrigin;
    private EAuditActionType m_eAction;
    private ESuccess m_eSuccess;
    private final ICommonsList<AuditField> m_aFields = new CommonsArrayList();

    @Nonnull
    public AuditEventBuilder setSettings(@Nonnull IAuditSettings iAuditSettings) {
        ValueEnforcer.notNull((Object)iAuditSettings, (String)"Settings");
        this.m_aSettings = iAuditSettings;
        return this;
    }

    @Nonnull
    public AuditEventBuilder setCurrentUserIDProvider(@Nullable ICurrentUserIDProvider iCurrentUserIDProvider) {
        this.m_aCurrentUserIDProvider = iCurrentUserIDProvider;
        return this;
    }

    @Nonnull
    public AuditEventBuilder setActor(@Nullable String string) {
        this.m_sActor = string;
        return this;
    }

    @Nonnull
    public AuditEventBuilder setOrigin(@Nullable String string) {
        this.m_sOrigin = string;
        return this;
    }

    @Nonnull
    public AuditEventBuilder setAction(@Nullable EAuditActionType eAuditActionType) {
        this.m_eAction = eAuditActionType;
        return this;
    }

    @Nonnull
    public AuditEventBuilder setSucces(@Nullable ESuccess eSuccess) {
        this.m_eSuccess = eSuccess;
        return this;
    }

    @Nonnull
    public AuditEventBuilder addField(@Nullable AuditField auditField) {
        if (auditField != null) {
            this.m_aFields.add((Object)auditField);
        }
        return this;
    }

    @Nonnull
    public AuditEventBuilder addField(@Nullable String string, @Nullable String string2) {
        if (string != null || string2 != null) {
            return this.addField(new AuditField(string, string2));
        }
        return this;
    }

    @Nonnull
    public AuditEventBuilder addFieldHiddenValue(@Nullable String string) {
        return this.addField(AuditField.createWithHiddenValue(string));
    }

    @Nullable
    public String getRealActorID() {
        if (StringHelper.hasText((String)this.m_sActor)) {
            return this.m_sActor;
        }
        if (this.m_aCurrentUserIDProvider != null) {
            return this.m_aCurrentUserIDProvider.getCurrentUserID();
        }
        return null;
    }

    @Nonnull
    public AuditEvent build() {
        long l = this.m_aSettings.getAuditEventIDProvider().getAsLong();
        LocalDateTime localDateTime = this.m_aSettings.getAuditEventDateTimeProvider().get();
        String string = this.getRealActorID();
        return new AuditEvent(l, localDateTime, string, this.m_sOrigin, this.m_eAction, this.m_eSuccess, this.m_aFields);
    }
}

