/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit.v2.domain;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.v2.domain.AuditEvent;
import com.helger.photon.audit.v2.domain.AuditField;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AuditEventMicroTypeConverter
implements IMicroTypeConverter<AuditEvent> {
    public static final IMicroQName ATTR_ID = new MicroQName("id");
    public static final IMicroQName ATTR_CDT = new MicroQName("cdt");
    public static final IMicroQName ATTR_ACTOR = new MicroQName("actor");
    public static final IMicroQName ATTR_ORIGIN = new MicroQName("origin");
    public static final IMicroQName ATTR_ACTION = new MicroQName("action");
    public static final IMicroQName ATTR_SUCCESS = new MicroQName("success");
    public static final String ELEMENT_FIELD = "field";
    public static final IMicroQName ATTR_NAME = new MicroQName("name");
    public static final IMicroQName ATTR_VALUE = new MicroQName("value");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull AuditEvent auditEvent, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, auditEvent.getID());
        microElement.setAttributeWithConversion(ATTR_CDT, (Object)auditEvent.getCreationDateTime());
        microElement.setAttribute(ATTR_ACTOR, auditEvent.getActor());
        microElement.setAttribute(ATTR_ORIGIN, auditEvent.getOrigin());
        microElement.setAttribute(ATTR_ACTION, auditEvent.getActionID());
        if (auditEvent.hasSuccess()) {
            microElement.setAttribute(ATTR_SUCCESS, auditEvent.getSuccess().isSuccess());
        }
        for (AuditField auditField : auditEvent.fields()) {
            ((IMicroElement)microElement.appendElement(string, ELEMENT_FIELD).setAttribute(ATTR_NAME, auditField.getName())).setAttribute(ATTR_VALUE, auditField.getValue());
        }
        return microElement;
    }

    @Nonnull
    public AuditEvent convertToNative(@Nonnull IMicroElement iMicroElement) {
        long l = iMicroElement.getAttributeValueAsLong(ATTR_ID, -1L);
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_CDT, LocalDateTime.class);
        String string = iMicroElement.getAttributeValue(ATTR_ACTOR);
        String string2 = iMicroElement.getAttributeValue(ATTR_ORIGIN);
        String string3 = iMicroElement.getAttributeValue(ATTR_ACTION);
        EAuditActionType eAuditActionType = EAuditActionType.getFromIDOrNull(string3);
        if (eAuditActionType == null && StringHelper.hasText((String)string3)) {
            throw new IllegalStateException("Failed to parse action type '" + string3 + "'");
        }
        String string4 = iMicroElement.getAttributeValue(ATTR_SUCCESS);
        ESuccess eSuccess = StringHelper.hasNoText((String)string4) ? null : ESuccess.valueOf((boolean)StringParser.parseBool((String)string4));
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_FIELD)) {
            commonsArrayList.add((Object)new AuditField(iMicroElement2.getAttributeValue(ATTR_NAME), iMicroElement2.getAttributeValue(ATTR_VALUE)));
        }
        return new AuditEvent(l, localDateTime, string, string2, eAuditActionType, eSuccess, (ICommonsList<AuditField>)commonsArrayList);
    }
}

