/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.audit.IAuditItem;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AuditItemList {
    private final ICommonsList<IAuditItem> m_aItems = new CommonsArrayList();

    void internalKeepOnlyLast() {
        IAuditItem iAuditItem = (IAuditItem)this.m_aItems.getLastOrNull();
        this.m_aItems.clear();
        this.m_aItems.add((Object)iAuditItem);
    }

    void internalAddItem(@Nonnull IAuditItem iAuditItem) {
        ValueEnforcer.notNull((Object)iAuditItem, (String)"Item");
        this.m_aItems.add((Object)iAuditItem);
    }

    @Nonnegative
    public int getItemCount() {
        return this.m_aItems.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAuditItem> getAllItems() {
        return (ICommonsList)this.m_aItems.getClone();
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public List<IAuditItem> getLastItems(@Nonnegative int n) {
        int n2 = Math.min(n, this.m_aItems.size());
        return this.m_aItems.getSorted(Comparator.comparing(IAuditItem::getDateTime).reversed()).subList(0, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuditItemList auditItemList = (AuditItemList)object;
        return this.m_aItems.equals(auditItemList.m_aItems);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aItems).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("items", this.m_aItems).getToString();
    }
}

