/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.photon.audit.AuditItem;
import com.helger.photon.audit.EAuditActionType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AuditItemMicroTypeConverter
implements IMicroTypeConverter<AuditItem> {
    public static final String ELEMENT_ITEM = "item";
    public static final IMicroQName ATTR_DT = new MicroQName("ldt");
    public static final IMicroQName ATTR_USER = new MicroQName("user");
    public static final IMicroQName ATTR_TYPE = new MicroQName("type");
    public static final IMicroQName ATTR_SUCCESS = new MicroQName("success");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull AuditItem auditItem, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttributeWithConversion(ATTR_DT, (Object)auditItem.getDateTime());
        microElement.setAttribute(ATTR_USER, auditItem.getUserID());
        microElement.setAttribute(ATTR_TYPE, auditItem.getTypeID());
        microElement.setAttribute(ATTR_SUCCESS, auditItem.isSuccess());
        microElement.appendText((CharSequence)auditItem.getAction());
        return microElement;
    }

    @Nonnull
    public AuditItem convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string;
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_DT, LocalDateTime.class);
        if (localDateTime == null && (localDateTime = LocalDateTime.parse(string = iMicroElement.getAttributeValue("dts"))) == null) {
            throw new IllegalStateException("Failed to parse date time '" + string + "'");
        }
        string = iMicroElement.getAttributeValue(ATTR_USER);
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalStateException("Failed to find user ID");
        }
        String string2 = iMicroElement.getAttributeValue(ATTR_TYPE);
        EAuditActionType eAuditActionType = EAuditActionType.getFromIDOrNull(string2);
        if (eAuditActionType == null) {
            throw new IllegalStateException("Failed to parse action type '" + string2 + "'");
        }
        String string3 = iMicroElement.getAttributeValue(ATTR_SUCCESS);
        if (string3 == null) {
            string3 = iMicroElement.getAttributeValue("succes");
        }
        ESuccess eSuccess = ESuccess.valueOf((boolean)StringParser.parseBool((String)string3));
        String string4 = iMicroElement.getTextContent();
        return new AuditItem(localDateTime, string, eAuditActionType, eSuccess, string4);
    }
}

