/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.StringHelper;
import com.helger.photon.audit.AbstractAuditor;
import com.helger.photon.audit.IAuditItem;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAuditor
extends AbstractAuditor {
    public static final String VALUE_SUCCESS = "success";
    public static final String VALUE_FAILURE = "failure";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingAuditor.class);
    private final String m_sCommonPrefix;

    public LoggingAuditor(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider) {
        this(iCurrentUserIDProvider, "");
    }

    public LoggingAuditor(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider, @Nullable String string) {
        super(iCurrentUserIDProvider);
        this.m_sCommonPrefix = StringHelper.getNotNull((String)string, (String)"");
    }

    @Nonnull
    public String getCommonPrefix() {
        return this.m_sCommonPrefix;
    }

    @Nonnull
    @OverrideOnDemand
    public static String getDefaultAuditItemString(@Nonnull IAuditItem iAuditItem) {
        return DateTimeFormatter.ISO_DATE_TIME.format(iAuditItem.getDateTime()) + " " + iAuditItem.getUserID() + " " + iAuditItem.getType().getID() + " " + (iAuditItem.isSuccess() ? VALUE_SUCCESS : VALUE_FAILURE) + " " + iAuditItem.getAction();
    }

    @Nonnull
    @OverrideOnDemand
    protected String getAuditItemString(@Nonnull IAuditItem iAuditItem) {
        return this.m_sCommonPrefix + LoggingAuditor.getDefaultAuditItemString(iAuditItem);
    }

    @Override
    protected void handleAuditItem(@Nonnull IAuditItem iAuditItem) {
        LOGGER.info(this.getAuditItemString(iAuditItem));
    }
}

