/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit.v2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.ESuccess;
import com.helger.commons.type.ObjectType;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.IAuditor;
import com.helger.photon.audit.v2.AuditEventBuilder;
import com.helger.photon.audit.v2.domain.AuditEvent;
import com.helger.photon.audit.v2.pipeline.IAuditEventConsumer;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Audit2Bridge
implements IAuditor {
    public static final String AUDIT_FIELD_OBJECT_TYPE = "ObjectType";
    public static final String AUDIT_FIELD_USER_ACTION = "UserAction";
    private final ICurrentUserIDProvider m_aCurrentUserIDProvider;
    private final IAuditEventConsumer m_aAuditEventConsumer;
    private final Function<Object, String> m_aToStringConverter;

    public Audit2Bridge(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider, @Nonnull IAuditEventConsumer iAuditEventConsumer, @Nonnull Function<Object, String> function) {
        ValueEnforcer.notNull((Object)iCurrentUserIDProvider, (String)"CurrentUserIDProvider");
        ValueEnforcer.notNull((Object)iAuditEventConsumer, (String)"AuditEventConsumer");
        ValueEnforcer.notNull(function, (String)"ToStringConverter");
        this.m_aCurrentUserIDProvider = iCurrentUserIDProvider;
        this.m_aAuditEventConsumer = iAuditEventConsumer;
        this.m_aToStringConverter = function;
    }

    @Nonnull
    public final ICurrentUserIDProvider getCurrentUserIDProvider() {
        return this.m_aCurrentUserIDProvider;
    }

    @Nonnull
    public final IAuditEventConsumer getAuditEventConsumer() {
        return this.m_aAuditEventConsumer;
    }

    @Override
    public void createAuditItem(@Nonnull EAuditActionType eAuditActionType, @Nonnull ESuccess eSuccess, @Nullable ObjectType objectType, @Nullable String string, Object ... objectArray) {
        AuditEventBuilder auditEventBuilder = new AuditEventBuilder().setCurrentUserIDProvider(this.m_aCurrentUserIDProvider).setAction(eAuditActionType).setSucces(eSuccess);
        if (objectType != null) {
            auditEventBuilder.addField(AUDIT_FIELD_OBJECT_TYPE, objectType.getName());
        }
        if (string != null) {
            auditEventBuilder.addField(AUDIT_FIELD_USER_ACTION, string);
        }
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string2 = this.m_aToStringConverter.apply(object);
                auditEventBuilder.addField(null, string2);
            }
        }
        AuditEvent auditEvent = auditEventBuilder.build();
        this.m_aAuditEventConsumer.consumeAuditEvent(auditEvent);
    }
}

