/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit.v2.domain;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.IHasLongID;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.domain.IHasCreationDateTime;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.v2.domain.AuditField;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AuditEvent
implements Serializable,
IHasLongID,
IHasCreationDateTime {
    private final long m_nID;
    private final LocalDateTime m_aCreationDT;
    private final String m_sActor;
    private final String m_sOrigin;
    private final EAuditActionType m_eAction;
    private final ESuccess m_eSuccess;
    private final ICommonsList<AuditField> m_aFields = new CommonsArrayList();

    public AuditEvent(long l, @Nonnull LocalDateTime localDateTime, @Nullable String string, @Nullable String string2, @Nullable EAuditActionType eAuditActionType, @Nullable ESuccess eSuccess, @Nullable ICommonsList<AuditField> iCommonsList) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"CreationDT");
        this.m_nID = l;
        this.m_aCreationDT = localDateTime;
        this.m_sActor = string;
        this.m_sOrigin = string2;
        this.m_eAction = eAuditActionType;
        this.m_eSuccess = eSuccess;
        if (iCommonsList != null) {
            this.m_aFields.addAll(iCommonsList);
        }
    }

    public final long getID() {
        return this.m_nID;
    }

    @Nonnull
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    @Nullable
    public String getActor() {
        return this.m_sActor;
    }

    public boolean hasActor() {
        return StringHelper.hasText((String)this.m_sActor);
    }

    @Nullable
    public String getOrigin() {
        return this.m_sOrigin;
    }

    public boolean hasOrigin() {
        return StringHelper.hasText((String)this.m_sOrigin);
    }

    @Nullable
    public EAuditActionType getAction() {
        return this.m_eAction;
    }

    @Nullable
    public String getActionID() {
        return this.m_eAction == null ? null : this.m_eAction.getID();
    }

    public boolean hasAction() {
        return this.m_eAction != null;
    }

    @Nullable
    public ESuccess getSuccess() {
        return this.m_eSuccess;
    }

    public boolean hasSuccess() {
        return this.m_eSuccess != null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<AuditField> getAllFields() {
        return (ICommonsList)this.m_aFields.getClone();
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<AuditField> fields() {
        return this.m_aFields;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuditEvent auditEvent = (AuditEvent)object;
        return this.m_nID == auditEvent.m_nID && this.m_aCreationDT.equals(auditEvent.m_aCreationDT) && EqualsHelper.equals((Object)this.m_sActor, (Object)auditEvent.m_sActor) && EqualsHelper.equals((Object)this.m_sOrigin, (Object)auditEvent.m_sOrigin) && EqualsHelper.equals((Object)((Object)this.m_eAction), (Object)((Object)auditEvent.m_eAction)) && EqualsHelper.equals((Object)this.m_eSuccess, (Object)auditEvent.m_eSuccess) && this.m_aFields.equals(auditEvent.m_aFields);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nID).append((Object)this.m_aCreationDT).append((Object)this.m_sActor).append((Object)this.m_sOrigin).append((Enum)this.m_eAction).append((Enum)this.m_eSuccess).append(this.m_aFields).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", this.m_nID).append("CreationDT", (Object)this.m_aCreationDT).appendIfNotNull("Actor", (Object)this.m_sActor).appendIfNotNull("Origin", (Object)this.m_sOrigin).appendIfNotNull("Action", (Object)this.m_eAction).appendIfNotNull("Success", (Object)this.m_eSuccess).append("Fields", this.m_aFields).getToString();
    }
}

