/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.metadata;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.html.metadata.IHCLinkType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHCLinkType implements IHCLinkType
{
    CONTENTS("contents"),
    CHAPTER("chapter", true),
    SECTION("section", true),
    SUBSECTION("subsection", true),
    INDEX("index"),
    GLOSSARY("glossary"),
    APPENDIX("appendix", true),
    SEARCH("search"),
    AUTHOR("author"),
    COPYRIGHT("copyright"),
    NEXT("next"),
    PREV("prev"),
    FIRST("first"),
    LAST("last"),
    UP("up"),
    TOP("top"),
    START("start"),
    HELP("help"),
    BOOKMARK("bookmark", true),
    STYLESHEET("stylesheet", true),
    ALTERNATE("alternate", true),
    ALTERNATE_STYLESHEET("alternate stylesheet", true),
    SHORTCUT_ICON("shortcut icon"),
    ICON("icon"),
    LICENSE("license"),
    NOFOLLOW("nofollow"),
    NOREFERRER("noreferrer"),
    PREFETCH("prefetch"),
    TAG("tag"),
    MANIFEST("manifest"),
    APPLE_TOUCH_ICON("apple-touch-icon"),
    APPLE_TOUCH_ICON_PRECOMPOSED("apple-touch-icon-precomposed"),
    APPLE_TOUCH_STARTUP_IMAGE("apple-touch-startup-image"),
    DC_SCHEMA("schema.DC"),
    DC_SCHEMA_TERMS("schema.DCTERMS");

    private final String m_sAttrValue;
    private final boolean m_bAllowedMoreThanOnce;

    private EHCLinkType(String string2) {
        this(string2, false);
    }

    private EHCLinkType(String string2, boolean bl) {
        this.m_sAttrValue = string2;
        this.m_bAllowedMoreThanOnce = bl;
    }

    @Nonnull
    @Nonempty
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Override
    public boolean isAllowedMoreThanOnce() {
        return this.m_bAllowedMoreThanOnce;
    }

    @Nullable
    public static EHCLinkType getFromAttrValueOrNull(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (EHCLinkType)EnumHelper.findFirst(EHCLinkType.class, eHCLinkType -> eHCLinkType.hasAttrValue(string));
    }
}

