/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.metadata;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.metadata.EHCLinkType;
import com.helger.html.hc.html.metadata.HCBase;
import com.helger.html.hc.html.metadata.HCCSSNodeDetector;
import com.helger.html.hc.html.metadata.HCLink;
import com.helger.html.hc.html.metadata.HCMeta;
import com.helger.html.hc.html.metadata.HCTitle;
import com.helger.html.hc.html.script.HCJSNodeDetector;
import com.helger.xml.microdom.IMicroElement;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCHead
extends AbstractHCElement<HCHead> {
    private String m_sProfile;
    private final HCTitle m_aPageTitle = new HCTitle();
    private final HCBase m_aBase = new HCBase();
    private final ICommonsList<HCMeta> m_aMetaElements = new CommonsArrayList();
    private final ICommonsList<HCLink> m_aLinks = new CommonsArrayList();
    private final ICommonsList<IHCNode> m_aCSS = new CommonsArrayList();
    private final ICommonsList<IHCNode> m_aJS = new CommonsArrayList();

    public HCHead() {
        super(EHTMLElement.HEAD);
    }

    @Nullable
    public final String getProfile() {
        return this.m_sProfile;
    }

    @Nonnull
    public final HCHead setProfile(@Nullable String string) {
        this.m_sProfile = string;
        return this;
    }

    @Nullable
    public final String getPageTitle() {
        return this.m_aPageTitle.getContent();
    }

    @Nonnull
    public final HCHead setPageTitle(@Nullable String string) {
        this.m_aPageTitle.setContent(string);
        return this;
    }

    @Nullable
    public final ISimpleURL getBaseHref() {
        return this.m_aBase.getHref();
    }

    @Nonnull
    public final HCHead setBaseHref(@Nullable ISimpleURL iSimpleURL) {
        this.m_aBase.setHref(iSimpleURL);
        return this;
    }

    @Nullable
    public final HC_Target getBaseTarget() {
        return this.m_aBase.getTarget();
    }

    @Nonnull
    public final HCHead setBaseTarget(@Nullable HC_Target hC_Target) {
        this.m_aBase.setTarget(hC_Target);
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<HCMeta> metaElements() {
        return this.m_aMetaElements;
    }

    @Nonnull
    public final EChange removeMetaElement(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            return EChange.valueOf((boolean)this.m_aMetaElements.removeIf(hCMeta -> string.equals(hCMeta.getName()) || string.equals(hCMeta.getHttpEquiv())));
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<HCLink> links() {
        return this.m_aLinks;
    }

    @Nonnull
    public final HCHead setShortcutIconHref(@Nullable ISimpleURL iSimpleURL) {
        if (iSimpleURL == null) {
            this.m_aLinks.removeIf(hCLink -> hCLink.getRel().equals(EHCLinkType.SHORTCUT_ICON) || hCLink.getRel().equals(EHCLinkType.ICON));
        } else {
            this.m_aLinks.add((Object)new HCLink().setRel(EHCLinkType.SHORTCUT_ICON).setHref(iSimpleURL));
            this.m_aLinks.add((Object)new HCLink().setRel(EHCLinkType.ICON).setType(CMimeType.IMAGE_ICON).setHref(iSimpleURL));
        }
        return this;
    }

    @Nonnull
    public final HCHead addCSS(@Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"CSS");
        if (!HCCSSNodeDetector.isCSSNode(iHCNode)) {
            throw new IllegalArgumentException(iHCNode + " is not a valid CSS node!");
        }
        this.m_aCSS.add((Object)iHCNode);
        return this;
    }

    @Nonnull
    public final HCHead addCSSAt(@Nonnegative int n, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"CSS");
        if (!HCCSSNodeDetector.isCSSNode(iHCNode)) {
            throw new IllegalArgumentException(iHCNode + " is not a valid CSS node!");
        }
        this.m_aCSS.add(n, (Object)iHCNode);
        return this;
    }

    @Nonnegative
    public final int getCSSCount() {
        return this.m_aCSS.size();
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<IHCNode> cssNodes() {
        return this.m_aCSS;
    }

    @Nonnull
    @ReturnsImmutableObject
    public final ICommonsIterable<IHCNode> getCSSNodes() {
        return this.m_aCSS;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IHCNode> getAllCSSNodes() {
        return (ICommonsList)this.m_aCSS.getClone();
    }

    public final void getAllAndRemoveAllCSSNodes(@Nonnull List<IHCNode> list) {
        ValueEnforcer.notNull(list, (String)"TargetList");
        list.addAll((Collection<IHCNode>)this.m_aCSS);
        this.m_aCSS.clear();
    }

    @Nonnull
    public final HCHead removeAllCSS() {
        this.m_aCSS.clear();
        return this;
    }

    @Nonnull
    public final HCHead addJS(@Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"JS");
        if (!HCJSNodeDetector.isJSNode(iHCNode)) {
            throw new IllegalArgumentException(iHCNode + " is not a valid JS node!");
        }
        this.m_aJS.add((Object)iHCNode);
        return this;
    }

    @Nonnull
    public final HCHead addJSAt(@Nonnegative int n, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"JS");
        if (!HCJSNodeDetector.isJSNode(iHCNode)) {
            throw new IllegalArgumentException(iHCNode + " is not a valid JS node!");
        }
        this.m_aJS.add(n, (Object)iHCNode);
        return this;
    }

    @Nonnegative
    public final int getJSCount() {
        return this.m_aJS.size();
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<IHCNode> jsNodes() {
        return this.m_aJS;
    }

    @Nonnull
    @ReturnsImmutableObject
    public final ICommonsIterable<IHCNode> getJSNodes() {
        return this.m_aJS;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IHCNode> getAllJSNodes() {
        return (ICommonsList)this.m_aJS.getClone();
    }

    public final void getAllAndRemoveAllJSNodes(@Nonnull List<IHCNode> list) {
        ValueEnforcer.notNull(list, (String)"TargetList");
        list.addAll((Collection<IHCNode>)this.m_aJS);
        this.m_aJS.clear();
    }

    @Nonnull
    public final HCHead removeAllJS() {
        this.m_aJS.clear();
        return this;
    }

    @OverrideOnDemand
    protected void emitLinks(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        for (HCLink hCLink : this.m_aLinks) {
            iMicroElement.appendChild(hCLink.convertToMicroNode(iHCConversionSettingsToNode));
        }
    }

    @OverrideOnDemand
    protected void emitCSS(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        int n = 0;
        for (IHCNode iHCNode : this.m_aCSS) {
            if (iHCNode instanceof HCLink) {
                ++n;
            }
            iMicroElement.appendChild(iHCNode.convertToMicroNode(iHCConversionSettingsToNode));
        }
        if (iHCConversionSettingsToNode.areConsistencyChecksEnabled()) {
            HCConsistencyChecker.checkForMaximumCSSResources(n);
        }
    }

    @OverrideOnDemand
    protected void emitJS(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        for (IHCNode iHCNode : this.m_aJS) {
            iMicroElement.appendChild(iHCNode.convertToMicroNode(iHCConversionSettingsToNode));
        }
    }

    @Override
    protected void fillMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.hasText((String)this.m_sProfile)) {
            iMicroElement.setAttribute(CHTMLAttributes.PROFILE, this.m_sProfile);
        }
        for (HCMeta hCMeta : this.m_aMetaElements) {
            iMicroElement.appendChild(hCMeta.convertToMicroNode(iHCConversionSettingsToNode));
        }
        iMicroElement.appendChild(this.m_aPageTitle.convertToMicroNode(iHCConversionSettingsToNode));
        iMicroElement.appendChild(this.m_aBase.convertToMicroNode(iHCConversionSettingsToNode));
        this.emitLinks(iMicroElement, iHCConversionSettingsToNode);
        this.emitCSS(iMicroElement, iHCConversionSettingsToNode);
        this.emitJS(iMicroElement, iHCConversionSettingsToNode);
        if (!iMicroElement.hasChildren() && EHTMLElement.HEAD.mayNotBeSelfClosed()) {
            iMicroElement.appendText((CharSequence)"");
        }
    }

    @Override
    @Nonnull
    public String getPlainText() {
        return this.m_aPageTitle.getPlainText();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IHCNode> getAllChildren() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        commonsArrayList.add((Object)this.m_aPageTitle);
        commonsArrayList.add((Object)this.m_aBase);
        commonsArrayList.addAll(this.m_aMetaElements);
        commonsArrayList.addAll(this.m_aLinks);
        commonsArrayList.addAll(this.m_aCSS);
        commonsArrayList.addAll(this.m_aJS);
        return commonsArrayList;
    }

    @Nonnull
    public final ICommonsIterable<IHCNode> getChildren() {
        return this.getAllChildren();
    }

    @Override
    @Nullable
    public final IHCNode getChildAtIndex(@Nonnegative int n) {
        if (n == 0) {
            return this.m_aPageTitle;
        }
        if (n == 1) {
            return this.m_aBase;
        }
        int n2 = 2;
        int n3 = n2 + this.m_aMetaElements.size();
        if (n >= n2 && n < n3) {
            return (IHCNode)this.m_aMetaElements.getAtIndex(n - n2);
        }
        n2 = n3;
        n3 = n2 + this.m_aLinks.size();
        if (n >= n2 && n < n3) {
            return (IHCNode)this.m_aLinks.getAtIndex(n - n2);
        }
        n2 = n3;
        n3 = n2 + this.m_aCSS.size();
        if (n >= n2 && n < n3) {
            return (IHCNode)this.m_aCSS.getAtIndex(n - n2);
        }
        n2 = n3;
        n3 = n2 + this.m_aJS.size();
        if (n >= n2 && n < n3) {
            return (IHCNode)this.m_aJS.getAtIndex(n - n2);
        }
        return null;
    }

    @Override
    @Nullable
    public final IHCNode getFirstChild() {
        return this.m_aPageTitle;
    }

    @Override
    @Nullable
    public final IHCNode getLastChild() {
        if (this.m_aJS.isNotEmpty()) {
            return (IHCNode)this.m_aJS.getLast();
        }
        if (this.m_aCSS.isNotEmpty()) {
            return (IHCNode)this.m_aCSS.getLast();
        }
        if (this.m_aLinks.isNotEmpty()) {
            return (IHCNode)this.m_aLinks.getLast();
        }
        if (this.m_aMetaElements.isNotEmpty()) {
            return (IHCNode)this.m_aMetaElements.getLast();
        }
        return this.m_aBase;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2 + this.m_aMetaElements.size() + this.m_aLinks.size() + this.m_aCSS.size() + this.m_aJS.size();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("profile", (Object)this.m_sProfile).append("pageTitle", (Object)this.m_aPageTitle).append("base", (Object)this.m_aBase).append("metaElements", this.m_aMetaElements).append("links", this.m_aLinks).append("CSS", this.m_aCSS).append("JS", this.m_aJS).getToString();
    }
}

