/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.script;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.EHCScriptInlineMode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.script.AbstractHCScript;
import com.helger.html.hc.html.script.IHCScriptInline;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.html.js.IJSWriterSettings;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroNodeWithChildren;
import com.helger.xml.microdom.MicroText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCScriptInline<IMPLTYPE extends AbstractHCScriptInline<IMPLTYPE>>
extends AbstractHCScript<IMPLTYPE>
implements IHCScriptInline<IMPLTYPE> {
    public static final boolean DEFAULT_EMIT_AFTER_FILES = true;
    private IHasJSCode m_aJSProvider;
    private EHCScriptInlineMode m_eScriptMode = HCSettings.getScriptInlineMode();
    private boolean m_bEmitAfterFiles = true;
    private transient String m_sCachedJSCode;

    protected AbstractHCScriptInline() {
    }

    protected AbstractHCScriptInline(@Nonnull IHasJSCode iHasJSCode) {
        this();
        this.setJSCodeProvider(iHasJSCode);
    }

    @Override
    @Nonnull
    public final IHasJSCode getJSCodeProvider() {
        return this.m_aJSProvider;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setJSCodeProvider(@Nonnull IHasJSCode iHasJSCode) {
        this.m_aJSProvider = (IHasJSCode)ValueEnforcer.notNull((Object)iHasJSCode, (String)"Provider");
        return (IMPLTYPE)((AbstractHCScriptInline)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getJSCode(@Nonnull IJSWriterSettings iJSWriterSettings) {
        if (this.m_aJSProvider == null) {
            return null;
        }
        if (this.m_aJSProvider instanceof IHasJSCodeWithSettings) {
            return ((IHasJSCodeWithSettings)this.m_aJSProvider).getJSCode(iJSWriterSettings);
        }
        return this.m_aJSProvider.getJSCode();
    }

    @Override
    @Nonnull
    public final EHCScriptInlineMode getMode() {
        return this.m_eScriptMode;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMode(@Nonnull EHCScriptInlineMode eHCScriptInlineMode) {
        this.m_eScriptMode = (EHCScriptInlineMode)((Object)ValueEnforcer.notNull((Object)((Object)eHCScriptInlineMode), (String)"Mode"));
        return (IMPLTYPE)((AbstractHCScriptInline)this.thisAsT());
    }

    @Override
    public final boolean isEmitAfterFiles() {
        return this.m_bEmitAfterFiles;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setEmitAfterFiles(boolean bl) {
        this.m_bEmitAfterFiles = bl;
        return (IMPLTYPE)((AbstractHCScriptInline)this.thisAsT());
    }

    public static void setInlineScript(@Nonnull IMicroNodeWithChildren iMicroNodeWithChildren, @Nullable String string, @Nonnull EHCScriptInlineMode eHCScriptInlineMode, @Nonnull String string2) {
        if (StringHelper.hasText((String)string)) {
            switch (eHCScriptInlineMode) {
                case PLAIN_TEXT: {
                    iMicroNodeWithChildren.appendText((CharSequence)string);
                    break;
                }
                case PLAIN_TEXT_NO_ESCAPE: {
                    if (StringHelper.containsIgnoreCase((String)string, (String)"</script>", (Locale)Locale.US)) {
                        throw new IllegalArgumentException("The script text contains a closing script tag: " + string);
                    }
                    iMicroNodeWithChildren.appendChild((IMicroNode)new MicroText((CharSequence)string).setEscape(false));
                    break;
                }
                case PLAIN_TEXT_WRAPPED_IN_COMMENT: {
                    if (StringHelper.getLastChar((CharSequence)string) == '\n') {
                        iMicroNodeWithChildren.appendComment((CharSequence)(string2 + string + "//"));
                        break;
                    }
                    iMicroNodeWithChildren.appendComment((CharSequence)(string2 + string + string2 + "//"));
                    break;
                }
                case CDATA: {
                    iMicroNodeWithChildren.appendCDATA((CharSequence)string);
                    break;
                }
                case CDATA_IN_COMMENT: {
                    iMicroNodeWithChildren.appendText((CharSequence)"//");
                    if (StringHelper.getLastChar((CharSequence)string) == '\n') {
                        iMicroNodeWithChildren.appendCDATA((CharSequence)(string2 + string + "//"));
                        break;
                    }
                    iMicroNodeWithChildren.appendCDATA((CharSequence)(string2 + string + string2 + "//"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal mode: " + (Object)((Object)eHCScriptInlineMode));
                }
            }
        }
    }

    @Override
    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        if (this.m_sCachedJSCode == null) {
            this.m_sCachedJSCode = StringHelper.trim((String)this.getJSCode(iHCConversionSettingsToNode.getJSWriterSettings()));
        }
        return StringHelper.hasText((String)this.m_sCachedJSCode);
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        AbstractHCScriptInline.setInlineScript((IMicroNodeWithChildren)iMicroElement, this.m_sCachedJSCode, this.m_eScriptMode, iHCConversionSettingsToNode.getXMLWriterSettings().getNewLineString());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("JSProvider", (Object)this.m_aJSProvider).append("ScriptMode", (Enum)this.m_eScriptMode).append("EmitAfterFiles", this.m_bEmitAfterFiles).append("CachedJSCode", (Object)this.m_sCachedJSCode).getToString();
    }
}

