/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.special;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.StringHelper;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.EHCNodeState;
import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.config.IHCOnDocumentReadyProvider;
import com.helger.html.hc.html.IHCConditionalCommentNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.metadata.HCCSSNodeDetector;
import com.helger.html.hc.html.metadata.HCLink;
import com.helger.html.hc.html.metadata.HCStyle;
import com.helger.html.hc.html.script.AbstractHCScriptInline;
import com.helger.html.hc.html.script.HCJSNodeDetector;
import com.helger.html.hc.html.script.HCScriptFile;
import com.helger.html.hc.html.script.HCScriptInline;
import com.helger.html.hc.html.script.HCScriptInlineOnDocumentReady;
import com.helger.html.hc.html.script.IHCScriptInline;
import com.helger.html.hc.impl.AbstractHCNode;
import com.helger.html.hc.special.AbstractHCSpecialNodes;
import com.helger.html.hc.special.IHCSpecialNodeListModifier;
import com.helger.html.hc.special.InlineCSSList;
import com.helger.html.hc.special.SpecialNodeListModifier;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.resource.css.ICSSCodeProvider;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class HCSpecialNodeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HCSpecialNodeHandler.class);
    private static final AnnotationUsageCache s_aOOBNAnnotationCache = new AnnotationUsageCache(OutOfBandNode.class);
    private static final AnnotationUsageCache s_aSNLMAnnotationCache = new AnnotationUsageCache(SpecialNodeListModifier.class);
    private static final ICommonsMap<String, IHCSpecialNodeListModifier> s_aModifiers = new CommonsHashMap();
    private static final HCSpecialNodeHandler INSTANCE = new HCSpecialNodeHandler();

    private HCSpecialNodeHandler() {
    }

    public static boolean isOutOfBandNode(@Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"HCNode");
        if (s_aOOBNAnnotationCache.hasAnnotation((Object)iHCNode)) {
            return true;
        }
        if (HCHelper.isWrappedNode(iHCNode)) {
            return HCSpecialNodeHandler.isOutOfBandNode(HCHelper.getUnwrappedNode(iHCNode));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void _recursiveExtractAndRemoveOutOfBandNodes(@Nonnull IHCNode iHCNode, @Nonnull List<IHCNode> list, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"ParentElement");
        if (!iHCNode.hasChildren()) return;
        boolean bl = HCSettings.isOutOfBandDebuggingEnabled();
        int n2 = 0;
        for (IHCNode iHCNode2 : iHCNode.getAllChildren()) {
            if (bl) {
                LOGGER.info(StringHelper.getRepeated((String)"  ", (int)n) + ClassHelper.getClassLocalName(iHCNode2.getClass()));
            }
            if (HCSpecialNodeHandler.isOutOfBandNode(iHCNode2)) {
                if (bl) {
                    LOGGER.info(StringHelper.getRepeated((String)"  ", (int)n) + "=> is an OOB node!");
                }
                list.add(iHCNode2);
                if (!(iHCNode instanceof IHCHasChildrenMutable)) throw new IllegalStateException("Cannot remove out-of-band node from " + iHCNode + " at index " + n2);
                ((IHCHasChildrenMutable)iHCNode).removeChildAt(n2);
            } else {
                ++n2;
            }
            HCSpecialNodeHandler._recursiveExtractAndRemoveOutOfBandNodes(iHCNode2, list, n + 1);
        }
    }

    public static void recursiveExtractAndRemoveOutOfBandNodes(@Nonnull IHCNode iHCNode, @Nonnull List<IHCNode> list) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"ParentElement");
        ValueEnforcer.notNull(list, (String)"TargetList");
        HCSpecialNodeHandler._recursiveExtractAndRemoveOutOfBandNodes(iHCNode, list, 0);
    }

    @Nonnull
    public static Iterable<? extends IHCNode> applyModifiers(@Nonnull Iterable<? extends IHCNode> iterable) {
        IHCSpecialNodeListModifier iHCSpecialNodeListModifier;
        ValueEnforcer.notNull(iterable, (String)"Nodes");
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        for (IHCNode object : iterable) {
            if (!s_aSNLMAnnotationCache.hasAnnotation((Object)object)) continue;
            commonsLinkedHashSet.add(object.getClass().getAnnotation(SpecialNodeListModifier.class).value());
        }
        if (commonsLinkedHashSet.isEmpty()) {
            return iterable;
        }
        for (Class clazz : commonsLinkedHashSet) {
            Object object = clazz.getName();
            if (s_aModifiers.containsKey(object)) continue;
            iHCSpecialNodeListModifier = (IHCSpecialNodeListModifier)GenericReflection.newInstance((Class)clazz);
            if (iHCSpecialNodeListModifier == null) {
                LOGGER.error("Failed to instantiate IHCSpecialNodeListModifier implementation " + clazz);
            }
            s_aModifiers.put(object, (Object)iHCSpecialNodeListModifier);
        }
        ICommonsList<? extends IHCNode> iCommonsList = new CommonsArrayList(iterable);
        for (Object object : commonsLinkedHashSet) {
            iHCSpecialNodeListModifier = (IHCSpecialNodeListModifier)s_aModifiers.get((Object)((Class)object).getName());
            if (iHCSpecialNodeListModifier == null) continue;
            iCommonsList = iHCSpecialNodeListModifier.modifySpecialNodes(iCommonsList);
        }
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCNode> getMergedInlineCSSAndJSNodes(@Nonnull Iterable<? extends IHCNode> iterable, boolean bl) {
        return HCSpecialNodeHandler.getMergedInlineCSSAndJSNodes(iterable, bl ? HCSettings.getOnDocumentReadyProvider() : null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCNode> getMergedInlineCSSAndJSNodes(@Nonnull Iterable<? extends IHCNode> iterable, @Nullable IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider) {
        Object object;
        Serializable serializable2;
        ValueEnforcer.notNull(iterable, (String)"Nodes");
        Iterable<? extends IHCNode> iterable2 = HCSpecialNodeHandler.applyModifiers(iterable);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CollectingJSCodeProvider collectingJSCodeProvider = new CollectingJSCodeProvider();
        CollectingJSCodeProvider collectingJSCodeProvider2 = new CollectingJSCodeProvider();
        CollectingJSCodeProvider collectingJSCodeProvider3 = new CollectingJSCodeProvider();
        CollectingJSCodeProvider collectingJSCodeProvider4 = new CollectingJSCodeProvider();
        InlineCSSList inlineCSSList = new InlineCSSList();
        InlineCSSList inlineCSSList2 = new InlineCSSList();
        for (IHCNode iHCNode : iterable2) {
            if (HCJSNodeDetector.isDirectJSInlineNode(iHCNode)) {
                if (iHCNode instanceof HCScriptInlineOnDocumentReady) {
                    serializable2 = (HCScriptInlineOnDocumentReady)iHCNode;
                    (((AbstractHCScriptInline)serializable2).isEmitAfterFiles() ? collectingJSCodeProvider2 : collectingJSCodeProvider).appendFlattened(((HCScriptInlineOnDocumentReady)serializable2).getOnDocumentReadyCode());
                    continue;
                }
                serializable2 = (IHCScriptInline)iHCNode;
                (serializable2.isEmitAfterFiles() ? collectingJSCodeProvider4 : collectingJSCodeProvider3).appendFlattened(serializable2.getJSCodeProvider());
                continue;
            }
            if (HCCSSNodeDetector.isDirectCSSInlineNode(iHCNode)) {
                serializable2 = (HCStyle)iHCNode;
                (((HCStyle)serializable2).isEmitAfterFiles() ? inlineCSSList2 : inlineCSSList).addInlineCSS(((HCStyle)serializable2).getMedia(), ((HCStyle)serializable2).getStyleContent());
                continue;
            }
            if (!(iHCNode instanceof HCLink || iHCNode instanceof HCScriptFile || iHCNode instanceof IHCConditionalCommentNode)) {
                LOGGER.warn("Found unexpected node to merge inline CSS/JS: " + iHCNode);
            }
            commonsArrayList.add((Object)iHCNode);
        }
        if (!collectingJSCodeProvider.isEmpty()) {
            if (iHCOnDocumentReadyProvider != null) {
                collectingJSCodeProvider3.append(iHCOnDocumentReadyProvider.createOnDocumentReady(collectingJSCodeProvider));
            } else {
                collectingJSCodeProvider3.append(collectingJSCodeProvider);
            }
        }
        if (!collectingJSCodeProvider2.isEmpty()) {
            if (iHCOnDocumentReadyProvider != null) {
                collectingJSCodeProvider4.append(iHCOnDocumentReadyProvider.createOnDocumentReady(collectingJSCodeProvider2));
            } else {
                collectingJSCodeProvider4.append(collectingJSCodeProvider2);
            }
        }
        if (!collectingJSCodeProvider3.isEmpty()) {
            object = (HCScriptInline)new HCScriptInline(collectingJSCodeProvider3).setEmitAfterFiles(false);
            ((AbstractHCNode)object).internalSetNodeState(EHCNodeState.RESOURCES_REGISTERED);
            commonsArrayList.add(0, object);
        }
        if (!collectingJSCodeProvider4.isEmpty()) {
            object = (HCScriptInline)new HCScriptInline(collectingJSCodeProvider4).setEmitAfterFiles(true);
            ((AbstractHCNode)object).internalSetNodeState(EHCNodeState.RESOURCES_REGISTERED);
            commonsArrayList.add(object);
        }
        if (inlineCSSList.isNotEmpty()) {
            int n = 0;
            for (Serializable serializable2 : inlineCSSList.getAll()) {
                HCStyle hCStyle = new HCStyle(serializable2.getCSSCode()).setMedia(serializable2.getMediaList()).setEmitAfterFiles(false);
                hCStyle.internalSetNodeState(EHCNodeState.RESOURCES_REGISTERED);
                commonsArrayList.add(n, (Object)hCStyle);
                ++n;
            }
        }
        if (inlineCSSList2.isNotEmpty()) {
            for (ICSSCodeProvider iCSSCodeProvider : inlineCSSList2.getAll()) {
                serializable2 = new HCStyle(iCSSCodeProvider.getCSSCode()).setMedia(iCSSCodeProvider.getMediaList()).setEmitAfterFiles(true);
                ((AbstractHCNode)serializable2).internalSetNodeState(EHCNodeState.RESOURCES_REGISTERED);
                commonsArrayList.add((Object)serializable2);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCNode> extractSpecialNodes(@Nonnull Iterable<? extends IHCNode> iterable, @Nonnull AbstractHCSpecialNodes<?> abstractHCSpecialNodes) {
        ValueEnforcer.notNull(iterable, (String)"Nodes");
        ValueEnforcer.notNull(abstractHCSpecialNodes, (String)"SpecialNodes");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IHCNode iHCNode : iterable) {
            IHCElement<HCLink> iHCElement;
            if (HCCSSNodeDetector.isDirectCSSFileNode(iHCNode)) {
                iHCElement = (HCLink)iHCNode;
                if (((HCLink)iHCElement).getHref() == null) continue;
                abstractHCSpecialNodes.addExternalCSS(((HCLink)iHCElement).getMedia(), ((HCLink)iHCElement).getHref().getAsStringWithEncodedParameters());
                continue;
            }
            if (HCCSSNodeDetector.isDirectCSSInlineNode(iHCNode)) {
                iHCElement = (HCStyle)iHCNode;
                if (((HCStyle)iHCElement).isEmitAfterFiles()) {
                    abstractHCSpecialNodes.addInlineCSSAfterExternal(((HCStyle)iHCElement).getMedia(), ((HCStyle)iHCElement).getStyleContent());
                    continue;
                }
                abstractHCSpecialNodes.addInlineCSSBeforeExternal(((HCStyle)iHCElement).getMedia(), ((HCStyle)iHCElement).getStyleContent());
                continue;
            }
            if (HCJSNodeDetector.isDirectJSFileNode(iHCNode)) {
                iHCElement = (HCScriptFile)iHCNode;
                if (((HCScriptFile)iHCElement).getSrc() == null) continue;
                abstractHCSpecialNodes.addExternalJS(((HCScriptFile)iHCElement).getSrc().getAsStringWithEncodedParameters());
                continue;
            }
            if (HCJSNodeDetector.isDirectJSInlineNode(iHCNode)) {
                iHCElement = (IHCScriptInline)iHCNode;
                if (iHCElement.isEmitAfterFiles()) {
                    abstractHCSpecialNodes.addInlineJSAfterExternal(iHCElement.getJSCodeProvider());
                    continue;
                }
                abstractHCSpecialNodes.addInlineJSBeforeExternal(iHCElement.getJSCodeProvider());
                continue;
            }
            commonsArrayList.add((Object)iHCNode);
        }
        return commonsArrayList;
    }

    public static void extractSpecialContent(@Nonnull IHCNode iHCNode, @Nonnull AbstractHCSpecialNodes<?> abstractHCSpecialNodes, boolean bl) {
        HCSpecialNodeHandler.extractSpecialContent(iHCNode, abstractHCSpecialNodes, bl ? HCSettings.getOnDocumentReadyProvider() : null);
    }

    public static void extractSpecialContent(@Nonnull IHCNode iHCNode, @Nonnull AbstractHCSpecialNodes<?> abstractHCSpecialNodes, @Nullable IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"Node");
        ValueEnforcer.notNull(abstractHCSpecialNodes, (String)"SpecialNodes");
        ICommonsList<IHCNode> iCommonsList = new ICommonsList<IHCNode>();
        HCSpecialNodeHandler.recursiveExtractAndRemoveOutOfBandNodes(iHCNode, (List<IHCNode>)iCommonsList);
        iCommonsList = HCSpecialNodeHandler.getMergedInlineCSSAndJSNodes((Iterable<? extends IHCNode>)iCommonsList, iHCOnDocumentReadyProvider);
        iCommonsList = HCSpecialNodeHandler.extractSpecialNodes(iCommonsList, abstractHCSpecialNodes);
        if (iCommonsList.isNotEmpty()) {
            throw new IllegalStateException("Out-of-band nodes are left after merging and extraction: " + iCommonsList);
        }
    }
}

