/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.html.js.IJSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CollectingJSCodeProvider
implements IHasJSCodeWithSettings,
IHasSize,
ICloneable<CollectingJSCodeProvider> {
    private final ICommonsList<IHasJSCode> m_aList = new CommonsArrayList();

    public CollectingJSCodeProvider() {
    }

    public CollectingJSCodeProvider(IHasJSCode ... iHasJSCodeArray) {
        if (iHasJSCodeArray != null) {
            for (IHasJSCode iHasJSCode : iHasJSCodeArray) {
                if (iHasJSCode == null) continue;
                this.append(iHasJSCode);
            }
        }
    }

    public CollectingJSCodeProvider(@Nullable Iterable<? extends IHasJSCode> iterable) {
        if (iterable != null) {
            for (IHasJSCode iHasJSCode : iterable) {
                if (iHasJSCode == null) continue;
                this.append(iHasJSCode);
            }
        }
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IHasJSCode> directAll() {
        return this.m_aList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IHasJSCode> getAll() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Nonnull
    public CollectingJSCodeProvider addAt(@Nonnegative int n, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            this.m_aList.add(n, (Object)iHasJSCode);
        }
        return this;
    }

    @Nonnull
    public CollectingJSCodeProvider addFlattenedAt(@Nonnegative int n, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (iHasJSCode instanceof CollectingJSCodeProvider) {
                this.m_aList.addAll(n, ((CollectingJSCodeProvider)iHasJSCode).m_aList);
            } else {
                this.m_aList.add(n, (Object)iHasJSCode);
            }
        }
        return this;
    }

    @Nonnull
    public CollectingJSCodeProvider append(@Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            this.m_aList.add((Object)iHasJSCode);
        }
        return this;
    }

    @Nonnull
    public CollectingJSCodeProvider appendFlattened(@Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (iHasJSCode instanceof CollectingJSCodeProvider) {
                this.m_aList.addAll(((CollectingJSCodeProvider)iHasJSCode).m_aList);
            } else {
                this.m_aList.add((Object)iHasJSCode);
            }
        }
        return this;
    }

    @Nonnull
    public CollectingJSCodeProvider prepend(@Nullable IHasJSCode iHasJSCode) {
        return this.addAt(0, iHasJSCode);
    }

    @Nonnull
    public CollectingJSCodeProvider prependFlattened(@Nullable IHasJSCode iHasJSCode) {
        return this.addFlattenedAt(0, iHasJSCode);
    }

    @Nonnull
    public CollectingJSCodeProvider removeAt(@Nonnegative int n) {
        this.m_aList.removeAtIndex(n);
        return this;
    }

    public void reset() {
        this.m_aList.clear();
    }

    @Nonnegative
    public int size() {
        return this.m_aList.size();
    }

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    @Override
    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (IHasJSCode iHasJSCode : this.m_aList) {
            String string = iHasJSCode instanceof IHasJSCodeWithSettings ? ((IHasJSCodeWithSettings)iHasJSCode).getJSCode(iJSWriterSettings) : iHasJSCode.getJSCode();
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public CollectingJSCodeProvider getClone() {
        return new CollectingJSCodeProvider((Iterable<? extends IHasJSCode>)this.m_aList);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CollectingJSCodeProvider collectingJSCodeProvider = (CollectingJSCodeProvider)object;
        return this.m_aList.equals(collectingJSCodeProvider.m_aList);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aList).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("list", this.m_aList, CollectionHelper::isNotEmpty).getToString();
    }
}

