/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.ENewLineMode;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSWriterDefaultSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JSWriterSettings
implements IJSWriterSettings,
ICloneable<JSWriterSettings> {
    private boolean m_bIndentAndAlign;
    private boolean m_bGenerateComments;
    private String m_sIndent;
    private ENewLineMode m_eNewLineMode;

    public JSWriterSettings() {
        this.m_bIndentAndAlign = JSWriterDefaultSettings.isIndentAndAlign();
        this.m_bGenerateComments = JSWriterDefaultSettings.isGenerateComments();
        this.m_sIndent = JSWriterDefaultSettings.getIndent();
        this.m_eNewLineMode = JSWriterDefaultSettings.getNewLineMode();
    }

    public JSWriterSettings(@Nonnull IJSWriterSettings iJSWriterSettings) {
        ValueEnforcer.notNull((Object)iJSWriterSettings, (String)"Other");
        this.m_bIndentAndAlign = iJSWriterSettings.isIndentAndAlign();
        this.m_bGenerateComments = iJSWriterSettings.isGenerateComments();
        this.m_sIndent = iJSWriterSettings.getIndent();
        this.m_eNewLineMode = iJSWriterSettings.getNewLineMode();
    }

    @Override
    public boolean isIndentAndAlign() {
        return this.m_bIndentAndAlign;
    }

    @Nonnull
    public JSWriterSettings setIndentAndAlign(boolean bl) {
        this.m_bIndentAndAlign = bl;
        return this;
    }

    @Override
    public boolean isGenerateComments() {
        return this.m_bGenerateComments;
    }

    @Nonnull
    public JSWriterSettings setGenerateComments(boolean bl) {
        this.m_bGenerateComments = bl;
        return this;
    }

    @Nonnull
    public JSWriterSettings setMinimumCodeSize(boolean bl) {
        this.setIndentAndAlign(!bl);
        this.setGenerateComments(!bl);
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getIndent() {
        return this.m_sIndent;
    }

    @Nonnull
    public JSWriterSettings setIndent(@Nonnull @Nonempty String string) {
        this.m_sIndent = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Indent");
        return this;
    }

    @Nonnull
    public JSWriterSettings setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        this.m_eNewLineMode = (ENewLineMode)ValueEnforcer.notNull((Object)eNewLineMode, (String)"NewLineMode");
        return this;
    }

    @Override
    @Nonnull
    public ENewLineMode getNewLineMode() {
        return this.m_eNewLineMode;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNewLineString() {
        return this.m_eNewLineMode.getText();
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSWriterSettings getClone() {
        return new JSWriterSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("IndentAndAlign", this.m_bIndentAndAlign).append("GenerateComments", this.m_bGenerateComments).append("Indent", (Object)this.m_sIndent).append("NewLineMode", (Enum)this.m_eNewLineMode).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static JSWriterSettings createCloneOnDemand(@Nullable IJSWriterSettings iJSWriterSettings) {
        return iJSWriterSettings == null ? new JSWriterSettings() : new JSWriterSettings(iJSWriterSettings);
    }
}

