/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js.tostring;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.ClassHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.JSMarshaller;
import com.helger.html.js.tostring.EJSType;
import com.helger.html.js.tostring.IHasChildJSType;
import com.helger.html.js.tostring.JSArrayType;
import com.helger.html.js.tostring.JSListType;
import com.helger.html.js.tostring.JSMapType;
import com.helger.html.js.tostring.JSType;
import com.helger.json.IJson;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSToString {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSToString.class);

    private JSToString() {
    }

    @Nullable
    private static JSType _autoDetectJSType(Class<?> clazz) {
        if (ClassHelper.isStringClass(clazz)) {
            return JSType.STRING;
        }
        if (ClassHelper.isCharacterClass(clazz)) {
            return JSType.STRING;
        }
        if (ClassHelper.isBooleanClass(clazz)) {
            return JSType.BOOLEAN;
        }
        if (ClassHelper.isFloatingPointClass(clazz)) {
            return JSType.DOUBLE;
        }
        if (ClassHelper.isIntegerClass(clazz)) {
            return JSType.INT;
        }
        if (ClassHelper.isArrayClass(clazz)) {
            return new JSArrayType(JSType.AUTO_DETECT);
        }
        if (IHasJSCode.class.isAssignableFrom(clazz)) {
            return JSType.JS;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new JSMapType(JSType.AUTO_DETECT, JSType.AUTO_DETECT);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new JSListType(JSType.AUTO_DETECT);
        }
        if (IJson.class.isAssignableFrom(clazz)) {
            return JSType.JSON;
        }
        LOGGER.warn("Failed to detect JS type of class " + clazz);
        return null;
    }

    @Nonnull
    private static JSType _getRealJSType(@Nullable Object object, @Nonnull JSType jSType) {
        if (!jSType.equals(JSType.AUTO_DETECT)) {
            return jSType;
        }
        if (object == null) {
            return JSType.VOID;
        }
        JSType jSType2 = JSToString._autoDetectJSType(object.getClass());
        if (jSType2 == null) {
            throw new IllegalArgumentException("Unsupported data type: " + object.getClass());
        }
        return jSType2;
    }

    private static void _toJSString(@Nullable Object object, @Nonnull JSType jSType, @Nonnull StringBuilder stringBuilder, @Nonnegative int n, boolean bl) {
        if (object == null) {
            stringBuilder.append("null");
        } else {
            switch (jSType.getType()) {
                case BOOLEAN: 
                case DOUBLE: {
                    stringBuilder.append(object.toString());
                    break;
                }
                case INT: {
                    if (object instanceof Number) {
                        stringBuilder.append(Long.toString(((Number)object).longValue()));
                        break;
                    }
                    stringBuilder.append(object.toString());
                    break;
                }
                case HTML: {
                    if (object instanceof IHCNode) {
                        stringBuilder.append(HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)object));
                        break;
                    }
                    stringBuilder.append((String)object);
                    break;
                }
                case JS: {
                    if (object instanceof IHasJSCode) {
                        stringBuilder.append(((IHasJSCode)object).getJSCode());
                        break;
                    }
                    stringBuilder.append((String)object);
                    break;
                }
                case JSON: {
                    stringBuilder.append(((IJson)object).getAsJsonString());
                    break;
                }
                case STRING: {
                    String string = String.valueOf(object);
                    stringBuilder.append('\'').append(JSMarshaller.javaScriptEscape(string)).append('\'');
                    break;
                }
                case ARRAY: 
                case LIST: {
                    if (!(jSType instanceof JSListType) && !(jSType instanceof JSArrayType)) {
                        throw new IllegalArgumentException("object is not a list: " + jSType);
                    }
                    JSType jSType2 = ((IHasChildJSType)((Object)jSType)).getChildType();
                    if (n == 0 && bl) {
                        stringBuilder.append("var x=");
                    }
                    stringBuilder.append('[');
                    int n2 = 0;
                    if (jSType.getType() == EJSType.ARRAY) {
                        Object[] objectArray;
                        for (Object object2 : objectArray = (Object[])object) {
                            if (n2++ > 0) {
                                stringBuilder.append(',');
                            }
                            JSToString._toJSString(object2, JSToString._getRealJSType(object2, jSType2), stringBuilder, n + 1, bl);
                        }
                    } else {
                        Collection collection = (Collection)object;
                        for (Object e : collection) {
                            if (n2++ > 0) {
                                stringBuilder.append(',');
                            }
                            JSToString._toJSString(e, JSToString._getRealJSType(e, jSType2), stringBuilder, n + 1, bl);
                        }
                    }
                    stringBuilder.append(']');
                    if (n != 0 || !bl) break;
                    stringBuilder.append(";x");
                    break;
                }
                case MAP: {
                    if (!(jSType instanceof JSMapType)) {
                        throw new IllegalArgumentException("object is not a map");
                    }
                    Map map = (Map)object;
                    JSType jSType3 = ((JSMapType)jSType).getKeyType();
                    JSType jSType4 = ((JSMapType)jSType).getValueType();
                    if (n == 0 && bl) {
                        stringBuilder.append("var x=");
                    }
                    stringBuilder.append('{');
                    int n3 = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        if (n3++ > 0) {
                            stringBuilder.append(',');
                        }
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        JSToString._toJSString(k, JSToString._getRealJSType(k, jSType3), stringBuilder, n + 1, bl);
                        stringBuilder.append(':');
                        JSToString._toJSString(v, JSToString._getRealJSType(v, jSType4), stringBuilder, n + 1, bl);
                    }
                    stringBuilder.append('}');
                    if (n != 0 || !bl) break;
                    stringBuilder.append(";x");
                    break;
                }
                case VOID: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)jSType.getType()));
                }
            }
        }
    }

    @Nonnull
    public static String objectToJSString(@Nullable Object object) {
        return JSToString.objectToJSString(object, JSType.AUTO_DETECT, false);
    }

    @Nonnull
    public static String objectToJSString(@Nullable Object object, @Nonnull JSType jSType) {
        return JSToString.objectToJSString(object, jSType, false);
    }

    @Nonnull
    public static String objectToJSString(@Nullable Object object, @Nonnull JSType jSType, boolean bl) {
        ValueEnforcer.notNull((Object)jSType, (String)"Type");
        StringBuilder stringBuilder = new StringBuilder();
        JSToString._toJSString(object, JSToString._getRealJSType(object, jSType), stringBuilder, 0, bl);
        return stringBuilder.toString();
    }
}

