/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js.tostring;

import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.js.tostring.IJSToStringConverter;
import com.helger.html.js.tostring.JSType;
import com.helger.json.IJson;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JsonToStringConverter
implements IJSToStringConverter,
Serializable {
    @Override
    @Nullable
    public String objectToJSString(@Nullable Object object, @Nonnull JSType jSType) {
        if (object != null && !(object instanceof IJson)) {
            throw new IllegalArgumentException("The passed object is not of type IJson but " + object.getClass().getName());
        }
        if (jSType != JSType.JSON) {
            throw new IllegalArgumentException("Unexpected JSType '" + jSType + "'! Only JSON is supported!");
        }
        return object == null ? null : ((IJson)object).getAsJsonString();
    }

    public boolean equals(Object object) {
        return object instanceof JsonToStringConverter;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

