/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.regex.RegExCache;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.entity.EHTMLEntity;
import com.helger.html.entity.HTMLEntity;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.embedded.AbstractHCImg;
import com.helger.html.hc.html.grouping.HCLI;
import com.helger.html.hc.html.textlevel.AbstractHCA;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.html.textlevel.HCAbbr;
import com.helger.html.hc.html.textlevel.HCCode;
import com.helger.html.hc.impl.HCCommentNode;
import com.helger.html.hc.impl.HCDOMWrapper;
import com.helger.html.hc.impl.HCEntityNode;
import com.helger.html.markdown.AbstractMarkdownPlugin;
import com.helger.html.markdown.Block;
import com.helger.html.markdown.EMarkToken;
import com.helger.html.markdown.IMarkdownDecorator;
import com.helger.html.markdown.Line;
import com.helger.html.markdown.LinkRef;
import com.helger.html.markdown.MarkdownConfiguration;
import com.helger.html.markdown.MarkdownException;
import com.helger.html.markdown.MarkdownHCStack;
import com.helger.html.markdown.MarkdownHTML;
import com.helger.html.markdown.MarkdownHelper;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

final class Emitter {
    private final ICommonsMap<String, LinkRef> m_aLinkRefs = new CommonsHashMap();
    private final MarkdownConfiguration m_aConfig;
    private boolean m_bUseExtensions = false;
    private final boolean m_bConvertNewline2Br;
    private final ICommonsMap<String, AbstractMarkdownPlugin> m_aPlugins = new CommonsHashMap();

    public Emitter(@Nonnull MarkdownConfiguration markdownConfiguration) {
        this.m_aConfig = markdownConfiguration;
        this.m_bUseExtensions = markdownConfiguration.isExtendedProfile();
        this.m_bConvertNewline2Br = markdownConfiguration.isConvertNewline2Br();
        for (AbstractMarkdownPlugin abstractMarkdownPlugin : markdownConfiguration.getAllPlugins()) {
            this.register(abstractMarkdownPlugin);
        }
    }

    void setUseExtensions(boolean bl) {
        this.m_bUseExtensions = bl;
    }

    public void register(@Nonnull AbstractMarkdownPlugin abstractMarkdownPlugin) {
        this.m_aPlugins.put((Object)abstractMarkdownPlugin.getPluginID(), (Object)abstractMarkdownPlugin);
    }

    public void addLinkRef(@Nonnull String string, LinkRef linkRef) {
        this.m_aLinkRefs.put((Object)string.toLowerCase(Locale.US), (Object)linkRef);
    }

    public void emit(MarkdownHCStack markdownHCStack, Block block) {
        Object object;
        block.removeSurroundingEmptyLines();
        IMarkdownDecorator iMarkdownDecorator = this.m_aConfig.getDecorator();
        switch (block.m_eType) {
            case RULER: {
                iMarkdownDecorator.appendHorizontalRuler(markdownHCStack);
                return;
            }
            case NONE: 
            case XML: 
            case XML_COMMENT: {
                break;
            }
            case HEADLINE: {
                object = iMarkdownDecorator.openHeadline(markdownHCStack, block.m_nHeadlineDepth);
                if (!this.m_bUseExtensions || block.m_sID == null) break;
                object.setID(block.m_sID);
                break;
            }
            case PARAGRAPH: {
                iMarkdownDecorator.openParagraph(markdownHCStack);
                break;
            }
            case CODE: 
            case FENCED_CODE: {
                if (this.m_aConfig.getCodeBlockEmitter() != null) break;
                iMarkdownDecorator.openCodeBlock(markdownHCStack);
                break;
            }
            case BLOCKQUOTE: {
                iMarkdownDecorator.openBlockquote(markdownHCStack);
                break;
            }
            case UNORDERED_LIST: {
                iMarkdownDecorator.openUnorderedList(markdownHCStack);
                break;
            }
            case ORDERED_LIST: {
                iMarkdownDecorator.openOrderedList(markdownHCStack);
                break;
            }
            case LIST_ITEM: {
                HCLI hCLI = iMarkdownDecorator.openListItem(markdownHCStack);
                if (!this.m_bUseExtensions || block.m_sID == null) break;
                hCLI.setID(block.m_sID);
                break;
            }
        }
        if (block.hasLines()) {
            this._emitLines(markdownHCStack, block);
        } else {
            object = block.m_aBlocks;
            while (object != null) {
                this.emit(markdownHCStack, (Block)object);
                object = ((Block)object).m_aNext;
            }
        }
        switch (block.m_eType) {
            case RULER: 
            case NONE: 
            case XML: 
            case XML_COMMENT: {
                break;
            }
            case HEADLINE: {
                iMarkdownDecorator.closeHeadline(markdownHCStack, block.m_nHeadlineDepth);
                break;
            }
            case PARAGRAPH: {
                iMarkdownDecorator.closeParagraph(markdownHCStack);
                break;
            }
            case CODE: 
            case FENCED_CODE: {
                if (this.m_aConfig.getCodeBlockEmitter() != null) break;
                iMarkdownDecorator.closeCodeBlock(markdownHCStack);
                break;
            }
            case BLOCKQUOTE: {
                iMarkdownDecorator.closeBlockquote(markdownHCStack);
                break;
            }
            case UNORDERED_LIST: {
                iMarkdownDecorator.closeUnorderedList(markdownHCStack);
                break;
            }
            case ORDERED_LIST: {
                iMarkdownDecorator.closeOrderedList(markdownHCStack);
                break;
            }
            case LIST_ITEM: {
                iMarkdownDecorator.closeListItem(markdownHCStack);
                break;
            }
        }
    }

    private void _emitLines(MarkdownHCStack markdownHCStack, Block block) {
        switch (block.m_eType) {
            case CODE: {
                this._emitCodeLines(markdownHCStack, block.m_aLines, block.m_sMeta, true);
                break;
            }
            case FENCED_CODE: {
                this._emitCodeLines(markdownHCStack, block.m_aLines, block.m_sMeta, false);
                break;
            }
            case PLUGIN: {
                this.emitPluginLines(markdownHCStack, block.m_aLines, block.m_sMeta);
                break;
            }
            case XML: {
                this._emitXMLLines(markdownHCStack, block.m_aLines);
                break;
            }
            case XML_COMMENT: {
                Emitter._emitXMLComment(markdownHCStack, block.m_aLines);
                break;
            }
            case PARAGRAPH: {
                this._emitMarkedLines(markdownHCStack, block.m_aLines);
                break;
            }
            default: {
                this._emitMarkedLines(markdownHCStack, block.m_aLines);
            }
        }
    }

    private int _findInlineToken(String string, int n, EMarkToken eMarkToken) {
        for (int i = n; i < string.length(); ++i) {
            if (this._getToken(string, i) != eMarkToken) continue;
            return i;
        }
        return -1;
    }

    private int _checkInlineLink(MarkdownHCStack markdownHCStack, String string, int n, EMarkToken eMarkToken) {
        Object object;
        boolean bl = false;
        int n2 = n + (eMarkToken == EMarkToken.LINK ? 1 : 2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        n2 = MarkdownHelper.readMdLinkId(stringBuilder, string, n2);
        if (n2 < n) {
            return -1;
        }
        String string2 = stringBuilder.toString();
        String string3 = null;
        String string4 = null;
        int n3 = n2++;
        if ((n2 = MarkdownHelper.skipSpaces(string, n2)) < n) {
            object = (LinkRef)this.m_aLinkRefs.get((Object)string2.toLowerCase(Locale.US));
            if (object == null) {
                return -1;
            }
            bl = ((LinkRef)object).isAbbrev();
            string3 = ((LinkRef)object).getLink();
            string4 = ((LinkRef)object).getTitle();
            n2 = n3;
        } else if (string.charAt(n2) == '(') {
            ++n2;
            if ((n2 = MarkdownHelper.skipSpaces(string, n2)) < n) {
                return -1;
            }
            stringBuilder.setLength(0);
            boolean bl2 = string.charAt(n2) == '<';
            int n4 = n2 = bl2 ? MarkdownHelper.readUntil(stringBuilder, string, n2 + 1, '>') : MarkdownHelper.readMdLink(stringBuilder, string, n2);
            if (n2 < n) {
                return -1;
            }
            if (bl2) {
                ++n2;
            }
            string3 = stringBuilder.toString();
            if (string.charAt(n2) == ' ' && (n2 = MarkdownHelper.skipSpaces(string, n2)) > n && string.charAt(n2) == '\"') {
                ++n2;
                stringBuilder.setLength(0);
                n2 = MarkdownHelper.readUntil(stringBuilder, string, n2, '\"');
                if (n2 < n) {
                    return -1;
                }
                string4 = stringBuilder.toString();
                ++n2;
                if ((n2 = MarkdownHelper.skipSpaces(string, n2)) == -1) {
                    return -1;
                }
            }
            if (string.charAt(n2) != ')') {
                return -1;
            }
        } else if (string.charAt(n2) == '[') {
            ++n2;
            stringBuilder.setLength(0);
            n2 = MarkdownHelper.readRawUntil(stringBuilder, string, n2, ']');
            if (n2 < n) {
                return -1;
            }
            object = stringBuilder.length() > 0 ? stringBuilder.toString() : string2;
            LinkRef linkRef = (LinkRef)this.m_aLinkRefs.get((Object)((String)object).toLowerCase(Locale.US));
            if (linkRef != null) {
                string3 = linkRef.getLink();
                string4 = linkRef.getTitle();
            }
        } else {
            object = (LinkRef)this.m_aLinkRefs.get((Object)string2.toLowerCase(Locale.US));
            if (object == null) {
                return -1;
            }
            bl = ((LinkRef)object).isAbbrev();
            string3 = ((LinkRef)object).getLink();
            string4 = ((LinkRef)object).getTitle();
            n2 = n3;
        }
        if (string3 == null) {
            return -1;
        }
        if (eMarkToken == EMarkToken.LINK) {
            if (bl && string4 != null) {
                if (!this.m_bUseExtensions) {
                    return -1;
                }
                markdownHCStack.push((IHCNodeWithChildren)((Object)new HCAbbr().setTitle(string4)));
                this._recursiveEmitLine(markdownHCStack, string2, 0, EMarkToken.NONE);
                markdownHCStack.pop();
            } else {
                object = this.m_aConfig.getDecorator().openLink(markdownHCStack);
                ((AbstractHCA)object).setHref((ISimpleURL)new SimpleURL(string3));
                if (string4 != null) {
                    ((AbstractHCElement)object).setTitle(string4);
                }
                this._recursiveEmitLine(markdownHCStack, string2, 0, EMarkToken.NONE);
                this.m_aConfig.getDecorator().closeLink(markdownHCStack);
            }
        } else {
            object = this.m_aConfig.getDecorator().appendImage(markdownHCStack);
            ((AbstractHCImg)object).setSrc((ISimpleURL)new SimpleURL(string3));
            ((AbstractHCImg)object).setAlt(string2);
            if (string4 != null) {
                ((AbstractHCElement)object).setTitle(string4);
            }
        }
        return n2;
    }

    private int _checkInlineHtml(MarkdownHCStack markdownHCStack, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        int n2 = MarkdownHelper.readUntil(stringBuilder, string, n + 1, ':', ' ', '>', '\n');
        if (n2 != -1 && string.charAt(n2) == ':' && MarkdownHTML.isLinkPrefix(stringBuilder.toString()) && (n2 = MarkdownHelper.readUntil(stringBuilder, string, n2, '>')) != -1) {
            String string2 = stringBuilder.toString();
            HCA hCA = this.m_aConfig.getDecorator().openLink(markdownHCStack);
            ((HCA)hCA.setHref((ISimpleURL)new SimpleURL(string2))).addChild(string2);
            this.m_aConfig.getDecorator().closeLink(markdownHCStack);
            return n2;
        }
        stringBuilder.setLength(0);
        n2 = MarkdownHelper.readUntil(stringBuilder, string, n + 1, '@', ' ', '>', '\n');
        if (n2 != -1 && string.charAt(n2) == '@' && (n2 = MarkdownHelper.readUntil(stringBuilder, string, n2, '>')) != -1) {
            String string3 = stringBuilder.toString();
            HCA hCA = this.m_aConfig.getDecorator().openLink(markdownHCStack);
            if (string3.startsWith("@")) {
                String string4 = string3.substring(1);
                ISimpleURL iSimpleURL = (ISimpleURL)new SimpleURL("https://maps.google.com/maps").add("q", string4);
                ((HCA)hCA.setHref(iSimpleURL)).addChild(string4);
            } else {
                ((HCA)hCA.setHref((ISimpleURL)new SimpleURL("mailto:" + string3))).addChild(string3);
            }
            this.m_aConfig.getDecorator().closeLink(markdownHCStack);
            return n2;
        }
        if (n + 2 < string.length()) {
            if (n + 3 < string.length() && string.charAt(n + 1) == '!' && string.charAt(n + 2) == '-' && string.charAt(n + 3) == '-') {
                int n3 = n2 = n + 4;
                while (true) {
                    if (n2 < string.length() && string.charAt(n2) != '-') {
                        ++n2;
                        continue;
                    }
                    if (n2 == string.length()) {
                        return -1;
                    }
                    if (n2 + 2 < string.length() && string.charAt(n2 + 1) == '-' && string.charAt(n2 + 2) == '>') {
                        markdownHCStack.append(new HCCommentNode(string.substring(n3, n2)));
                        return n2 + 2;
                    }
                    ++n2;
                }
            }
            stringBuilder.setLength(0);
            boolean bl = this.m_aConfig.isSafeMode();
            int n4 = MarkdownHelper.readXMLElement(stringBuilder, string, n, bl);
            if (n4 != -1) {
                String string5 = stringBuilder.toString();
                if (string5.endsWith("/>")) {
                    IMicroDocument iMicroDocument = MicroReader.readMicroXML((String)string5);
                    if (iMicroDocument == null) {
                        throw new MarkdownException("Failed to parse XML '" + string5 + "'");
                    }
                    markdownHCStack.append(new HCDOMWrapper(iMicroDocument.getDocumentElement().detachFromParent()));
                } else if (string5.startsWith("</")) {
                    markdownHCStack.pop();
                } else if (bl && string5.startsWith("&lt;")) {
                    markdownHCStack.append("<" + string5.substring(4));
                } else {
                    String string6 = string5.substring(0, string5.length() - 1) + "/>";
                    IMicroDocument iMicroDocument = MicroReader.readMicroXML((String)string6);
                    if (iMicroDocument == null) {
                        throw new MarkdownException("Failed to parse XML '" + string6 + "'");
                    }
                    IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
                    IHCElement<?> iHCElement = HCExtHelper.createHCElementFromName(iMicroElement.getTagName());
                    if (iHCElement == null) {
                        throw new MarkdownException("Failed to get HC element '" + iMicroElement.getTagName() + "'");
                    }
                    iMicroElement.forAllAttributes(iMicroAttribute -> iHCElement.customAttrs().putIn(iMicroAttribute.getAttributeQName(), iMicroAttribute.getAttributeValue()));
                    if (iHCElement.getElement().mayBeSelfClosed()) {
                        markdownHCStack.append(iHCElement);
                    } else {
                        markdownHCStack.push(iHCElement);
                    }
                }
                return n4 - 1;
            }
        }
        return -1;
    }

    private static int _checkInlineEntity(StringBuilder stringBuilder, String string, int n) {
        int n2 = MarkdownHelper.readUntil(stringBuilder, string, n, ';');
        if (n2 < 0 || stringBuilder.length() < 3) {
            return -1;
        }
        if (stringBuilder.charAt(1) == '#') {
            if (stringBuilder.charAt(2) == 'x' || stringBuilder.charAt(2) == 'X') {
                if (stringBuilder.length() < 4) {
                    return -1;
                }
                for (int i = 3; i < stringBuilder.length(); ++i) {
                    char c = stringBuilder.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                    return -1;
                }
            } else {
                for (int i = 2; i < stringBuilder.length(); ++i) {
                    char c = stringBuilder.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    return -1;
                }
            }
        } else {
            for (int i = 1; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
                return -1;
            }
            stringBuilder.append(';');
            return EHTMLEntity.isValidEntityReference(stringBuilder.toString()) ? n2 : -1;
        }
        stringBuilder.append(';');
        return n2;
    }

    private int _recursiveEmitLine(MarkdownHCStack markdownHCStack, String string, int n, EMarkToken eMarkToken) {
        MarkdownHCStack markdownHCStack2 = new MarkdownHCStack();
        StringBuilder stringBuilder = new StringBuilder();
        block22: for (int i = n; i < string.length(); ++i) {
            EMarkToken eMarkToken2 = this._getToken(string, i);
            if (eMarkToken != EMarkToken.NONE && (eMarkToken2.equals((Object)eMarkToken) || eMarkToken == EMarkToken.EM_STAR && eMarkToken2 == EMarkToken.STRONG_STAR || eMarkToken == EMarkToken.EM_UNDERSCORE && eMarkToken2 == EMarkToken.STRONG_UNDERSCORE)) {
                return i;
            }
            switch (eMarkToken2) {
                case IMAGE: 
                case LINK: {
                    int n2 = this._checkInlineLink(markdownHCStack, string, i, eMarkToken2);
                    if (n2 > 0) {
                        i = n2;
                        continue block22;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue block22;
                }
                case EM_STAR: 
                case EM_UNDERSCORE: {
                    markdownHCStack2.reset();
                    int n2 = this._recursiveEmitLine(markdownHCStack2, string, i + 1, eMarkToken2);
                    if (n2 > 0) {
                        this.m_aConfig.getDecorator().openEmphasis(markdownHCStack);
                        markdownHCStack.append(markdownHCStack2.getRoot());
                        this.m_aConfig.getDecorator().closeEmphasis(markdownHCStack);
                        i = n2;
                        continue block22;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue block22;
                }
                case STRONG_STAR: 
                case STRONG_UNDERSCORE: {
                    markdownHCStack2.reset();
                    int n2 = this._recursiveEmitLine(markdownHCStack2, string, i + 2, eMarkToken2);
                    if (n2 > 0) {
                        this.m_aConfig.getDecorator().openStrong(markdownHCStack);
                        markdownHCStack.append(markdownHCStack2.getRoot());
                        this.m_aConfig.getDecorator().closeStrong(markdownHCStack);
                        i = n2 + 1;
                        continue block22;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue block22;
                }
                case STRIKE: {
                    markdownHCStack2.reset();
                    int n2 = this._recursiveEmitLine(markdownHCStack2, string, i + 2, eMarkToken2);
                    if (n2 > 0) {
                        this.m_aConfig.getDecorator().openStrike(markdownHCStack);
                        markdownHCStack.append(markdownHCStack2.getRoot());
                        this.m_aConfig.getDecorator().closeStrike(markdownHCStack);
                        i = n2 + 1;
                        continue block22;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue block22;
                }
                case SUPER: {
                    markdownHCStack2.reset();
                    int n2 = this._recursiveEmitLine(markdownHCStack2, string, i + 1, eMarkToken2);
                    if (n2 > 0) {
                        this.m_aConfig.getDecorator().openSuper(markdownHCStack);
                        markdownHCStack.append(markdownHCStack2.getRoot());
                        this.m_aConfig.getDecorator().closeSuper(markdownHCStack);
                        i = n2;
                        continue block22;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue block22;
                }
                case CODE_SINGLE: 
                case CODE_DOUBLE: {
                    int n3 = i + (eMarkToken2 == EMarkToken.CODE_DOUBLE ? 2 : 1);
                    int n2 = this._findInlineToken(string, n3, eMarkToken2);
                    if (n2 > 0) {
                        i = n2 + (eMarkToken2 == EMarkToken.CODE_DOUBLE ? 1 : 0);
                        while (n3 < n2 && string.charAt(n3) == ' ') {
                            ++n3;
                        }
                        if (n3 >= n2) continue block22;
                        while (string.charAt(n2 - 1) == ' ') {
                            --n2;
                        }
                        HCCode hCCode = this.m_aConfig.getDecorator().openCodeSpan(markdownHCStack);
                        hCCode.addChild(string.substring(n3, n2));
                        this.m_aConfig.getDecorator().closeCodeSpan(markdownHCStack);
                        continue block22;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue block22;
                }
                case HTML: {
                    int n2 = this._checkInlineHtml(markdownHCStack, string, i);
                    if (n2 > 0) {
                        i = n2;
                        continue block22;
                    }
                    markdownHCStack.append('<');
                    continue block22;
                }
                case ENTITY: {
                    stringBuilder.setLength(0);
                    int n2 = Emitter._checkInlineEntity(stringBuilder, string, i);
                    if (n2 > 0) {
                        markdownHCStack.append(new HCEntityNode(new HTMLEntity(stringBuilder.substring(1, stringBuilder.length() - 1)), " "));
                        i = n2;
                        continue block22;
                    }
                    markdownHCStack.append('&');
                    continue block22;
                }
                case X_LINK_OPEN: {
                    markdownHCStack2.reset();
                    int n2 = this._recursiveEmitLine(markdownHCStack2, string, i + 2, EMarkToken.X_LINK_CLOSE);
                    if (n2 > 0 && this.m_aConfig.getSpecialLinkEmitter() != null) {
                        this.m_aConfig.getSpecialLinkEmitter().emitSpan(markdownHCStack, markdownHCStack2);
                        i = n2 + 1;
                        continue block22;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue block22;
                }
                case X_COPY: {
                    markdownHCStack.append(HCEntityNode.newCopy());
                    i += 2;
                    continue block22;
                }
                case X_REG: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.copy, "(r)"));
                    i += 2;
                    continue block22;
                }
                case X_TRADE: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.trade, "TM"));
                    i += 3;
                    continue block22;
                }
                case X_NDASH: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.ndash, "--"));
                    ++i;
                    continue block22;
                }
                case X_MDASH: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.mdash, "---"));
                    i += 2;
                    continue block22;
                }
                case X_HELLIP: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.hellip, "..."));
                    i += 2;
                    continue block22;
                }
                case X_LAQUO: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.laquo, "<<"));
                    ++i;
                    continue block22;
                }
                case X_RAQUO: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.raquo, ">>"));
                    ++i;
                    continue block22;
                }
                case X_RDQUO: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.rdquo, "\""));
                    continue block22;
                }
                case X_LDQUO: {
                    markdownHCStack.append(new HCEntityNode(EHTMLEntity.ldquo, "\""));
                    continue block22;
                }
                case ESCAPE: {
                    markdownHCStack.append(string.charAt(++i));
                    continue block22;
                }
                default: {
                    markdownHCStack.append(string.charAt(i));
                }
            }
        }
        return -1;
    }

    private static char _whitespaceToSpace(char c) {
        return Character.isWhitespace(c) ? (char)' ' : (char)c;
    }

    @Nonnull
    private EMarkToken _getToken(String string, int n) {
        char c = n > 0 ? (char)Emitter._whitespaceToSpace(string.charAt(n - 1)) : (char)' ';
        char c2 = Emitter._whitespaceToSpace(string.charAt(n));
        char c3 = n + 1 < string.length() ? (char)Emitter._whitespaceToSpace(string.charAt(n + 1)) : (char)' ';
        int n2 = n + 2 < string.length() ? (int)Emitter._whitespaceToSpace(string.charAt(n + 2)) : 32;
        int n3 = n + 3 < string.length() ? (int)Emitter._whitespaceToSpace(string.charAt(n + 3)) : 32;
        switch (c2) {
            case '*': {
                if (c3 == '*') {
                    return c != ' ' || n2 != 32 ? EMarkToken.STRONG_STAR : EMarkToken.EM_STAR;
                }
                return c != ' ' || c3 != ' ' ? EMarkToken.EM_STAR : EMarkToken.NONE;
            }
            case '_': {
                if (c3 == '_') {
                    return c != ' ' || n2 != 32 ? EMarkToken.STRONG_UNDERSCORE : EMarkToken.EM_UNDERSCORE;
                }
                if (this.m_bUseExtensions) {
                    return Character.isLetterOrDigit(c) && c != '_' && Character.isLetterOrDigit(c3) ? EMarkToken.NONE : EMarkToken.EM_UNDERSCORE;
                }
                return c != ' ' || c3 != ' ' ? EMarkToken.EM_UNDERSCORE : EMarkToken.NONE;
            }
            case '~': {
                if (this.m_bUseExtensions && c3 == '~') {
                    return EMarkToken.STRIKE;
                }
                return EMarkToken.NONE;
            }
            case '!': {
                if (c3 == '[') {
                    return EMarkToken.IMAGE;
                }
                return EMarkToken.NONE;
            }
            case '[': {
                if (this.m_bUseExtensions && c3 == '[') {
                    return EMarkToken.X_LINK_OPEN;
                }
                return EMarkToken.LINK;
            }
            case ']': {
                if (this.m_bUseExtensions && c3 == ']') {
                    return EMarkToken.X_LINK_CLOSE;
                }
                return EMarkToken.NONE;
            }
            case '`': {
                return c3 == '`' ? EMarkToken.CODE_DOUBLE : EMarkToken.CODE_SINGLE;
            }
            case '\\': {
                if (MarkdownHelper.isEscapeChar(c3)) {
                    return EMarkToken.ESCAPE;
                }
                return EMarkToken.NONE;
            }
            case '<': {
                if (this.m_bUseExtensions && c3 == '<') {
                    return EMarkToken.X_LAQUO;
                }
                return EMarkToken.HTML;
            }
            case '&': {
                return EMarkToken.ENTITY;
            }
        }
        if (this.m_bUseExtensions) {
            switch (c2) {
                case '-': {
                    if (c3 != 45) break;
                    return n2 == 45 ? EMarkToken.X_MDASH : EMarkToken.X_NDASH;
                }
                case '^': {
                    return c == '^' || c3 == '^' ? EMarkToken.NONE : EMarkToken.SUPER;
                }
                case '>': {
                    if (c3 != 62) break;
                    return EMarkToken.X_RAQUO;
                }
                case '.': {
                    if (c3 != 46 || n2 != 46) break;
                    return EMarkToken.X_HELLIP;
                }
                case '(': {
                    if (c3 == 'C' && n2 == 41) {
                        return EMarkToken.X_COPY;
                    }
                    if (c3 == 'R' && n2 == 41) {
                        return EMarkToken.X_REG;
                    }
                    if (c3 != 84 || n2 != 77 || n3 != 41) break;
                    return EMarkToken.X_TRADE;
                }
                case '\"': {
                    if (!Character.isLetterOrDigit(c) && c3 != ' ') {
                        return EMarkToken.X_LDQUO;
                    }
                    if (c == 32 || Character.isLetterOrDigit(c3)) break;
                    return EMarkToken.X_RDQUO;
                }
            }
        }
        return EMarkToken.NONE;
    }

    private void _emitMarkedLines(MarkdownHCStack markdownHCStack, Line line) {
        StringBuilder stringBuilder = new StringBuilder();
        Line line2 = line;
        while (line2 != null) {
            if (!line2.m_bIsEmpty) {
                stringBuilder.append(line2.m_sValue.substring(line2.m_nLeading, line2.m_sValue.length() - line2.m_nTrailing));
                if (line2.m_nTrailing >= 2 && !this.m_bConvertNewline2Br) {
                    stringBuilder.append("<br />");
                }
            }
            if (line2.m_aNext != null) {
                stringBuilder.append('\n');
                if (this.m_bConvertNewline2Br) {
                    stringBuilder.append("<br />");
                }
            }
            line2 = line2.m_aNext;
        }
        this._recursiveEmitLine(markdownHCStack, stringBuilder.toString(), 0, EMarkToken.NONE);
    }

    private void _emitXMLLines(MarkdownHCStack markdownHCStack, Line line) {
        Line line2 = line;
        boolean bl = this.m_aConfig.isSafeMode();
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            while (line2 != null) {
                if (!line2.m_bIsEmpty) {
                    stringBuilder.append(line2.m_sValue.trim());
                }
                line2 = line2.m_aNext;
            }
            String string = stringBuilder.toString();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '<') {
                    stringBuilder.setLength(0);
                    int n = MarkdownHelper.readXMLElement(stringBuilder, string, i, bl);
                    if (n != -1) {
                        markdownHCStack.append(stringBuilder.toString());
                        i = n;
                        continue;
                    }
                    markdownHCStack.append(string.charAt(i));
                    continue;
                }
                markdownHCStack.append(string.charAt(i));
            }
        } else {
            IMicroDocument iMicroDocument;
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (line2 != null) {
                if (!line2.m_bIsEmpty) {
                    stringBuilder.append(line2.m_sValue.trim());
                    ++n;
                }
                line2 = line2.m_aNext;
            }
            String string = stringBuilder.toString();
            if (n == 1 && !string.contains("/>") && !string.contains("</")) {
                string = string.substring(0, string.length() - 1) + "/>";
            }
            if ((iMicroDocument = MicroReader.readMicroXML((String)string)) == null) {
                throw new MarkdownException("Failed to parse XML: " + string);
            }
            markdownHCStack.append(new HCDOMWrapper(iMicroDocument.getDocumentElement().detachFromParent()));
        }
    }

    private static void _emitXMLComment(MarkdownHCStack markdownHCStack, Line line) {
        Line line2 = line;
        StringBuilder stringBuilder = new StringBuilder();
        while (line2 != null) {
            if (!line2.m_bIsEmpty) {
                stringBuilder.append(line2.m_sValue);
            }
            stringBuilder.append('\n');
            line2 = line2.m_aNext;
        }
        String string = StringHelper.trimStartAndEnd((String)stringBuilder.toString().trim(), (String)"<!--", (String)"-->");
        markdownHCStack.append(new HCCommentNode(string));
    }

    private void _emitCodeLines(MarkdownHCStack markdownHCStack, Line line, @Nonnull String string, boolean bl) {
        Line line2 = line;
        if (this.m_aConfig.getCodeBlockEmitter() != null) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            while (line2 != null) {
                if (line2.m_bIsEmpty) {
                    commonsArrayList.add((Object)"");
                } else {
                    commonsArrayList.add((Object)(bl ? line2.m_sValue.substring(4) : line2.m_sValue));
                }
                line2 = line2.m_aNext;
            }
            this.m_aConfig.getCodeBlockEmitter().emitBlock(markdownHCStack, (List<String>)commonsArrayList, string);
        } else {
            while (line2 != null) {
                if (!line2.m_bIsEmpty) {
                    markdownHCStack.append(line2.m_sValue.substring(4));
                }
                markdownHCStack.append('\n');
                line2 = line2.m_aNext;
            }
        }
    }

    void emitPluginLines(MarkdownHCStack markdownHCStack, Line line, @Nonnull String string) {
        Line line2 = line;
        String string2 = string;
        String string3 = null;
        ICommonsMap<String, String> iCommonsMap = null;
        int n = string.indexOf(32);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            if (string3 != null) {
                iCommonsMap = Emitter.parsePluginParams(string3);
            }
        }
        if (iCommonsMap == null) {
            iCommonsMap = new ICommonsMap<String, String>();
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        while (line2 != null) {
            if (line2.m_bIsEmpty) {
                commonsArrayList.add((Object)"");
            } else {
                commonsArrayList.add((Object)line2.m_sValue);
            }
            line2 = line2.m_aNext;
        }
        AbstractMarkdownPlugin abstractMarkdownPlugin = (AbstractMarkdownPlugin)this.m_aPlugins.get((Object)string2);
        if (abstractMarkdownPlugin != null) {
            abstractMarkdownPlugin.emit(markdownHCStack, (List<String>)commonsArrayList, (Map<String, String>)iCommonsMap);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    static ICommonsMap<String, String> parsePluginParams(@Nonnull String string) {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        Pattern pattern = RegExCache.getPattern((String)"(\\w+)=\"*((?<=\")[^\"]+(?=\")|([^\\s]+))\"*");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            commonsHashMap.put((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return commonsHashMap;
    }
}

