/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.collection.impl.CommonsLinkedList;
import com.helger.html.EHTMLElement;
import com.helger.html.markdown.ELineType;
import com.helger.html.markdown.MarkdownHTML;
import com.helger.html.markdown.MarkdownHelper;
import javax.annotation.Nonnull;

@CodingStyleguideUnaware
final class Line {
    int m_nPos;
    int m_nLeading = 0;
    int m_nTrailing = 0;
    boolean m_bIsEmpty = true;
    String m_sValue;
    Line m_aPrevious;
    Line m_aNext;
    boolean m_bPrevEmpty;
    Line m_aXmlEndLine;

    public void init() {
        this.m_nLeading = 0;
        while (this.m_nLeading < this.m_sValue.length() && this.m_sValue.charAt(this.m_nLeading) == ' ') {
            ++this.m_nLeading;
        }
        if (this.m_nLeading == this.m_sValue.length()) {
            this.setEmpty();
        } else {
            this.m_bIsEmpty = false;
            this.m_nTrailing = 0;
            while (this.m_sValue.charAt(this.m_sValue.length() - this.m_nTrailing - 1) == ' ') {
                ++this.m_nTrailing;
            }
        }
    }

    public void initLeading() {
        this.m_nLeading = 0;
        while (this.m_nLeading < this.m_sValue.length() && this.m_sValue.charAt(this.m_nLeading) == ' ') {
            ++this.m_nLeading;
        }
        if (this.m_nLeading == this.m_sValue.length()) {
            this.setEmpty();
        }
    }

    public boolean skipSpaces() {
        while (this.m_nPos < this.m_sValue.length() && this.m_sValue.charAt(this.m_nPos) == ' ') {
            ++this.m_nPos;
        }
        return this.m_nPos < this.m_sValue.length();
    }

    public String readUntil(char ... cArray) {
        char n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = this.m_nPos; n2 < this.m_sValue.length(); ++n2) {
            char c;
            n = this.m_sValue.charAt(n2);
            if (n == '\\' && n2 + 1 < this.m_sValue.length()) {
                c = this.m_sValue.charAt(n2 + 1);
                if (MarkdownHelper.isEscapeChar(c)) {
                    stringBuilder.append(c);
                    ++n2;
                    continue;
                }
                stringBuilder.append(n);
                continue;
            }
            c = '\u0000';
            char[] cArray2 = cArray;
            int n3 = cArray2.length;
            for (int i = 0; i < n3; ++i) {
                char c2 = cArray2[i];
                if (n != c2) continue;
                c = '\u0001';
                break;
            }
            if (c != '\u0000') break;
            stringBuilder.append(n);
        }
        n = n2 < this.m_sValue.length() ? (char)this.m_sValue.charAt(n2) : (char)'\n';
        for (char c : cArray) {
            if (n != c) continue;
            this.m_nPos = n2;
            return stringBuilder.toString();
        }
        return null;
    }

    public void setEmpty() {
        this.m_sValue = "";
        this.m_nLeading = 0;
        this.m_nTrailing = 0;
        this.m_bIsEmpty = true;
        if (this.m_aNext != null) {
            this.m_aNext.m_bPrevEmpty = true;
        }
    }

    private int _countConsecutiveChars(char c) {
        int n = 0;
        for (int i = 0; i < this.m_sValue.length(); ++i) {
            char c2 = this.m_sValue.charAt(i);
            if (c2 == ' ') continue;
            if (c2 != c) {
                return 0;
            }
            ++n;
        }
        return n;
    }

    private int _countCharsStart(char c) {
        int n = 0;
        for (int i = 0; i < this.m_sValue.length(); ++i) {
            char c2 = this.m_sValue.charAt(i);
            if (c2 == ' ') continue;
            if (c2 != c) break;
            ++n;
        }
        return n;
    }

    @Nonnull
    public ELineType getLineType(boolean bl) {
        if (this.m_bIsEmpty) {
            return ELineType.EMPTY;
        }
        if (this.m_nLeading > 3) {
            return ELineType.CODE;
        }
        if (this.m_sValue.charAt(this.m_nLeading) == '#') {
            return ELineType.HEADLINE;
        }
        if (this.m_sValue.charAt(this.m_nLeading) == '>') {
            return ELineType.BQUOTE;
        }
        if (bl && this.m_sValue.length() - this.m_nLeading - this.m_nTrailing > 2 && (this.m_sValue.charAt(this.m_nLeading) == '`' || this.m_sValue.charAt(this.m_nLeading) == '~' || this.m_sValue.charAt(this.m_nLeading) == '%')) {
            if (this._countCharsStart('`') >= 3) {
                return ELineType.FENCED_CODE;
            }
            if (this._countCharsStart('~') >= 3) {
                return ELineType.FENCED_CODE;
            }
            if (this._countCharsStart('%') >= 3) {
                return ELineType.PLUGIN;
            }
        }
        if (this.m_sValue.length() - this.m_nLeading - this.m_nTrailing > 2 && (this.m_sValue.charAt(this.m_nLeading) == '*' || this.m_sValue.charAt(this.m_nLeading) == '-' || this.m_sValue.charAt(this.m_nLeading) == '_') && this._countConsecutiveChars(this.m_sValue.charAt(this.m_nLeading)) >= 3) {
            return ELineType.HR;
        }
        if (this.m_sValue.length() - this.m_nLeading >= 2 && this.m_sValue.charAt(this.m_nLeading + 1) == ' ') {
            switch (this.m_sValue.charAt(this.m_nLeading)) {
                case '*': 
                case '+': 
                case '-': {
                    return ELineType.ULIST;
                }
            }
        }
        if (this.m_sValue.length() - this.m_nLeading >= 3 && Character.isDigit(this.m_sValue.charAt(this.m_nLeading))) {
            int n;
            for (n = this.m_nLeading + 1; n < this.m_sValue.length() && Character.isDigit(this.m_sValue.charAt(n)); ++n) {
            }
            if (n + 1 < this.m_sValue.length() && this.m_sValue.charAt(n) == '.' && this.m_sValue.charAt(n + 1) == ' ') {
                return ELineType.OLIST;
            }
        }
        if (this.m_sValue.charAt(this.m_nLeading) == '<') {
            EHTMLElementType eHTMLElementType = this._checkHTML();
            if (eHTMLElementType == EHTMLElementType.TAG) {
                return ELineType.XML;
            }
            if (eHTMLElementType == EHTMLElementType.COMMENT) {
                return ELineType.XML_COMMENT;
            }
        }
        if (this.m_aNext != null && !this.m_aNext.m_bIsEmpty) {
            if (this.m_aNext.m_sValue.charAt(0) == '-' && this.m_aNext._countConsecutiveChars('-') > 0) {
                return ELineType.HEADLINE2;
            }
            if (this.m_aNext.m_sValue.charAt(0) == '=' && this.m_aNext._countConsecutiveChars('=') > 0) {
                return ELineType.HEADLINE1;
            }
        }
        return ELineType.OTHER;
    }

    private int _readXMLComment(Line line, int n) {
        Line line2 = line;
        if (n + 3 < line2.m_sValue.length() && line2.m_sValue.charAt(2) == '-' && line2.m_sValue.charAt(3) == '-') {
            int n2 = n + 4;
            while (line2 != null) {
                while (n2 < line2.m_sValue.length() && line2.m_sValue.charAt(n2) != '-') {
                    ++n2;
                }
                if (n2 == line2.m_sValue.length()) {
                    line2 = line2.m_aNext;
                    n2 = 0;
                    continue;
                }
                if (n2 + 2 < line2.m_sValue.length() && line2.m_sValue.charAt(n2 + 1) == '-' && line2.m_sValue.charAt(n2 + 2) == '>') {
                    this.m_aXmlEndLine = line2;
                    return n2 + 3;
                }
                ++n2;
            }
        }
        return -1;
    }

    public String stripID() {
        if (this.m_bIsEmpty || this.m_sValue.charAt(this.m_sValue.length() - this.m_nTrailing - 1) != '}') {
            return null;
        }
        int n = this.m_nLeading;
        boolean bl = false;
        block8: while (n < this.m_sValue.length() && !bl) {
            switch (this.m_sValue.charAt(n)) {
                case '\\': {
                    if (n + 1 < this.m_sValue.length() && this.m_sValue.charAt(n + 1) == '{') {
                        ++n;
                    }
                    ++n;
                    continue block8;
                }
                case '{': {
                    bl = true;
                    continue block8;
                }
            }
            ++n;
        }
        if (bl && n + 1 < this.m_sValue.length() && this.m_sValue.charAt(n + 1) == '#') {
            int n2;
            n = n2 = n + 2;
            bl = false;
            block9: while (n < this.m_sValue.length() && !bl) {
                switch (this.m_sValue.charAt(n)) {
                    case '\\': {
                        if (n + 1 < this.m_sValue.length() && this.m_sValue.charAt(n + 1) == '}') {
                            ++n;
                        }
                        ++n;
                        continue block9;
                    }
                    case '}': {
                        bl = true;
                        continue block9;
                    }
                }
                ++n;
            }
            if (bl) {
                String string = this.m_sValue.substring(n2, n).trim();
                this.m_sValue = this.m_nLeading != 0 ? this.m_sValue.substring(0, this.m_nLeading) + this.m_sValue.substring(this.m_nLeading, n2 - 2).trim() : this.m_sValue.substring(this.m_nLeading, n2 - 2).trim();
                this.m_nTrailing = 0;
                return string.length() > 0 ? string : null;
            }
        }
        return null;
    }

    @Nonnull
    private EHTMLElementType _checkHTML() {
        CommonsLinkedList commonsLinkedList = new CommonsLinkedList();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_sValue.charAt(this.m_nLeading + 1) == '!' && this._readXMLComment(this, this.m_nLeading) > 0) {
            return EHTMLElementType.COMMENT;
        }
        int n = MarkdownHelper.readXMLElement(stringBuilder, this.m_sValue, this.m_nLeading, false);
        if (n > -1) {
            String string = stringBuilder.toString();
            String string2 = MarkdownHelper.getXMLTag(string);
            if (!MarkdownHTML.isHtmlBlockElement(string2)) {
                return EHTMLElementType.NONE;
            }
            if (EHTMLElement.getFromTagNameOrNull(string2).mayBeSelfClosed()) {
                this.m_aXmlEndLine = this;
                return EHTMLElementType.TAG;
            }
            commonsLinkedList.add((Object)string2);
            Line line = this;
            while (line != null) {
                while (n < line.m_sValue.length() && line.m_sValue.charAt(n) != '<') {
                    ++n;
                }
                if (n >= line.m_sValue.length()) {
                    line = line.m_aNext;
                    n = 0;
                    continue;
                }
                stringBuilder.setLength(0);
                int n2 = MarkdownHelper.readXMLElement(stringBuilder, line.m_sValue, n, false);
                if (n2 > 0) {
                    string = stringBuilder.toString();
                    string2 = MarkdownHelper.getXMLTag(string);
                    if (MarkdownHTML.isHtmlBlockElement(string2) && !EHTMLElement.getFromTagNameOrNull(string2).mayBeSelfClosed()) {
                        if (string.charAt(1) == '/') {
                            if (!((String)commonsLinkedList.getLast()).equals(string2)) {
                                return EHTMLElementType.NONE;
                            }
                            commonsLinkedList.removeLast();
                        } else {
                            commonsLinkedList.add((Object)string2);
                        }
                    }
                    if (commonsLinkedList.isEmpty()) {
                        this.m_aXmlEndLine = line;
                        break;
                    }
                    n = n2;
                    continue;
                }
                ++n;
            }
            if (commonsLinkedList.isEmpty()) {
                return EHTMLElementType.TAG;
            }
        }
        return EHTMLElementType.NONE;
    }

    private static enum EHTMLElementType {
        NONE,
        TAG,
        COMMENT;

    }
}

