/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.commons.collection.ArrayHelper;
import com.helger.html.markdown.MarkdownHTML;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;

final class MarkdownHelper {
    private static final char[] ESCAPE_CHARS = new char[]{'\\', '[', ']', '(', ')', '{', '}', '#', '\"', '\'', '.', '>', '<', '*', '+', '-', '_', '!', '`', '^'};

    private MarkdownHelper() {
    }

    public static int rnd() {
        return ThreadLocalRandom.current().nextInt(1024);
    }

    public static int skipSpaces(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\n'); ++n2) {
        }
        return n2 < string.length() ? n2 : -1;
    }

    public static boolean isEscapeChar(char c) {
        return ArrayHelper.contains((char[])ESCAPE_CHARS, (char)c);
    }

    private static int _escape(StringBuilder stringBuilder, char c, int n) {
        if (MarkdownHelper.isEscapeChar(c)) {
            stringBuilder.append(c);
            return n + 1;
        }
        stringBuilder.append('\\');
        return n;
    }

    public static int readUntil(StringBuilder stringBuilder, String string, int n, char ... cArray) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c == '\\' && n2 + 1 < string.length()) {
                n2 = MarkdownHelper._escape(stringBuilder, string.charAt(n2 + 1), n2);
                continue;
            }
            boolean bl = false;
            for (char c2 : cArray) {
                if (c != c2) continue;
                bl = true;
                break;
            }
            if (bl) break;
            stringBuilder.append(c);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readUntil(StringBuilder stringBuilder, String string, int n, char c) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '\\' && n2 + 1 < string.length()) {
                n2 = MarkdownHelper._escape(stringBuilder, string.charAt(n2 + 1), n2);
                continue;
            }
            if (c2 == c) break;
            stringBuilder.append(c2);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readMdLink(StringBuilder stringBuilder, String string, int n) {
        int n2;
        int n3 = 1;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c == '\\' && n2 + 1 < string.length()) {
                n2 = MarkdownHelper._escape(stringBuilder, string.charAt(n2 + 1), n2);
                continue;
            }
            boolean bl = false;
            switch (c) {
                case '(': {
                    ++n3;
                    break;
                }
                case ' ': {
                    if (n3 != 1) break;
                    bl = true;
                    break;
                }
                case ')': {
                    if (--n3 != 0) break;
                    bl = true;
                    break;
                }
            }
            if (bl) break;
            stringBuilder.append(c);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readMdLinkId(StringBuilder stringBuilder, String string, int n) {
        int n2;
        int n3 = 1;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            boolean bl = false;
            switch (c) {
                case '\n': {
                    stringBuilder.append(' ');
                    break;
                }
                case '[': {
                    ++n3;
                    stringBuilder.append(c);
                    break;
                }
                case ']': {
                    if (--n3 == 0) {
                        bl = true;
                        break;
                    }
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            if (bl) break;
        }
        return n2 == string.length() ? -1 : n2;
    }

    private static int _readRawUntil(StringBuilder stringBuilder, String string, int n, char ... cArray) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            boolean bl = false;
            for (char c2 : cArray) {
                if (c != c2) continue;
                bl = true;
                break;
            }
            if (bl) break;
            stringBuilder.append(c);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readRawUntil(StringBuilder stringBuilder, String string, int n, char c) {
        char c2;
        int n2;
        for (n2 = n; n2 < string.length() && (c2 = string.charAt(n2)) != c; ++n2) {
            stringBuilder.append(c2);
        }
        return n2 == string.length() ? -1 : n2;
    }

    private static void _appendDecEntity(StringBuilder stringBuilder, char c) {
        stringBuilder.append("&#").append((int)c).append(';');
    }

    private static void _appendHexEntity(StringBuilder stringBuilder, char c) {
        stringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
    }

    public static void appendMailto(StringBuilder stringBuilder, String string, int n, int n2) {
        block3: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = MarkdownHelper.rnd();
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '@': {
                    if (n3 < 512) {
                        MarkdownHelper._appendDecEntity(stringBuilder, c);
                        continue block3;
                    }
                    MarkdownHelper._appendHexEntity(stringBuilder, c);
                    continue block3;
                }
                default: {
                    if (n3 < 32) {
                        stringBuilder.append(c);
                        continue block3;
                    }
                    if (n3 < 520) {
                        MarkdownHelper._appendDecEntity(stringBuilder, c);
                        continue block3;
                    }
                    MarkdownHelper._appendHexEntity(stringBuilder, c);
                }
            }
        }
    }

    @Nonnull
    public static String getXMLTag(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        if (string.charAt(1) == '/') {
            ++n;
        }
        while (Character.isLetterOrDigit(string.charAt(n))) {
            stringBuilder.append(string.charAt(n++));
        }
        return stringBuilder.toString().toLowerCase(Locale.US);
    }

    @CheckForSigned
    public static int readXMLElement(StringBuilder stringBuilder, String string, int n, boolean bl) {
        try {
            int n2;
            boolean bl2;
            if (string.charAt(n + 1) == '!') {
                stringBuilder.append("<!");
                return n + 1;
            }
            if (string.charAt(n + 1) == '/') {
                bl2 = true;
                n2 = n + 2;
            } else {
                bl2 = false;
                n2 = n + 1;
            }
            if (bl) {
                StringBuilder stringBuilder2 = new StringBuilder();
                if ((n2 = MarkdownHelper._readRawUntil(stringBuilder2, string, n2, ' ', '/', '>')) == -1) {
                    return -1;
                }
                String string2 = stringBuilder2.toString().trim();
                if (MarkdownHTML.isUnsafeHtmlElement(string2)) {
                    stringBuilder.append("&lt;");
                    if (bl2) {
                        stringBuilder.append('/');
                    }
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append('<');
                    if (bl2) {
                        stringBuilder.append('/');
                    }
                    stringBuilder.append(string2);
                }
            } else {
                stringBuilder.append('<');
                if (bl2) {
                    stringBuilder.append('/');
                }
                n2 = MarkdownHelper._readRawUntil(stringBuilder, string, n2, ' ', '/', '>');
            }
            if (n2 == -1) {
                return -1;
            }
            if (string.charAt(n2 = MarkdownHelper._readRawUntil(stringBuilder, string, n2, '/', '>')) == '/') {
                stringBuilder.append(" /");
                n2 = MarkdownHelper.readRawUntil(stringBuilder, string, n2 + 1, '>');
                if (n2 == -1) {
                    return -1;
                }
            }
            if (string.charAt(n2) == '>') {
                stringBuilder.append('>');
                return n2 + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
        return -1;
    }

    @Nonnull
    public static String getMetaFromFence(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c) || c == '`' || c == '~' || c == '%') continue;
            return string.substring(i).trim();
        }
        return "";
    }
}

