/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.markdown.Block;
import com.helger.html.markdown.EBlockType;
import com.helger.html.markdown.ELineType;
import com.helger.html.markdown.Emitter;
import com.helger.html.markdown.Line;
import com.helger.html.markdown.LinkRef;
import com.helger.html.markdown.MarkdownConfiguration;
import com.helger.html.markdown.MarkdownHCStack;
import com.helger.html.markdown.MarkdownHelper;
import com.helger.html.markdown.MarkdownProcessingResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;

public class MarkdownProcessor {
    private final Emitter m_aEmitter;
    final MarkdownConfiguration m_aConfig;
    private boolean m_bUseExtensions;

    public MarkdownProcessor() {
        this(MarkdownConfiguration.DEFAULT);
    }

    public MarkdownProcessor(@Nonnull MarkdownConfiguration markdownConfiguration) {
        ValueEnforcer.notNull((Object)markdownConfiguration, (String)"Config");
        this.m_aConfig = markdownConfiguration;
        this.m_bUseExtensions = markdownConfiguration.isExtendedProfile();
        this.m_aEmitter = new Emitter(this.m_aConfig);
    }

    @Nonnull
    private Block _readLines(@Nonnull Reader reader) throws IOException {
        Block block = new Block();
        StringBuilder stringBuilder = new StringBuilder(80);
        int n = reader.read();
        LinkRef linkRef = null;
        while (n != -1) {
            char c;
            stringBuilder.setLength(0);
            int n2 = 0;
            boolean bl = false;
            block7: while (!bl) {
                switch (n) {
                    case -1: {
                        bl = true;
                        continue block7;
                    }
                    case 10: {
                        n = reader.read();
                        if (n == 13) {
                            n = reader.read();
                        }
                        bl = true;
                        continue block7;
                    }
                    case 13: {
                        n = reader.read();
                        if (n == 10) {
                            n = reader.read();
                        }
                        bl = true;
                        continue block7;
                    }
                    case 9: {
                        int n3 = n2 + (4 - (n2 & 3));
                        while (n2 < n3) {
                            stringBuilder.append(' ');
                            ++n2;
                        }
                        n = reader.read();
                        continue block7;
                    }
                }
                ++n2;
                stringBuilder.append((char)n);
                n = reader.read();
            }
            Line line = new Line();
            line.m_sValue = stringBuilder.toString();
            line.init();
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            if (!line.m_bIsEmpty && line.m_nLeading < 4 && line.m_sValue.charAt(line.m_nLeading) == '[') {
                line.m_nPos = line.m_nLeading + 1;
                string = line.readUntil(']');
                if (string != null && line.m_nPos + 2 < line.m_sValue.length() && line.m_sValue.charAt(line.m_nPos + 1) == ':') {
                    line.m_nPos += 2;
                    line.skipSpaces();
                    if (line.m_sValue.charAt(line.m_nPos) == '<') {
                        ++line.m_nPos;
                        string2 = line.readUntil('>');
                        ++line.m_nPos;
                    } else {
                        string2 = line.readUntil(' ', '\n');
                    }
                    if (string2 != null) {
                        if (line.skipSpaces()) {
                            c = line.m_sValue.charAt(line.m_nPos);
                            if (c == '\"' || c == '\'' || c == '(') {
                                ++line.m_nPos;
                                string3 = line.readUntil(c == '(' ? (char)')' : (char)c);
                                if (string3 != null) {
                                    bl2 = true;
                                }
                            }
                        } else {
                            bl2 = true;
                        }
                    }
                }
            }
            if (bl2 && string != null && string2 != null) {
                if (string.equalsIgnoreCase("$profile$")) {
                    this.m_bUseExtensions = string2.equalsIgnoreCase("extended");
                    this.m_aEmitter.setUseExtensions(this.m_bUseExtensions);
                    linkRef = null;
                    continue;
                }
                LinkRef linkRef2 = new LinkRef(string2, string3, string3 != null && string2.length() == 1 && string2.charAt(0) == '*');
                this.m_aEmitter.addLinkRef(string, linkRef2);
                if (string3 != null) continue;
                linkRef = linkRef2;
                continue;
            }
            string3 = null;
            if (!line.m_bIsEmpty && linkRef != null) {
                line.m_nPos = line.m_nLeading;
                c = line.m_sValue.charAt(line.m_nPos);
                if (c == '\"' || c == '\'' || c == '(') {
                    ++line.m_nPos;
                    string3 = line.readUntil(c == '(' ? (char)')' : (char)c);
                }
                if (string3 != null) {
                    linkRef.setTitle(string3);
                }
                linkRef = null;
            }
            if (string3 != null) continue;
            line.m_nPos = 0;
            block.appendLine(line);
        }
        return block;
    }

    private void _initListBlock(@Nonnull Block block) {
        Line line = block.m_aLines;
        line = line.m_aNext;
        while (line != null) {
            ELineType eLineType = line.getLineType(this.m_bUseExtensions);
            if (eLineType == ELineType.OLIST || eLineType == ELineType.ULIST || !line.m_bIsEmpty && line.m_bPrevEmpty && line.m_nLeading == 0) {
                block.split((Line)line.m_aPrevious).m_eType = EBlockType.LIST_ITEM;
            }
            line = line.m_aNext;
        }
        block.split((Line)block.m_aLineTail).m_eType = EBlockType.LIST_ITEM;
    }

    private void _recurse(@Nonnull Block block, boolean bl) {
        Line line = block.m_aLines;
        if (bl) {
            block.removeListIndent(this.m_bUseExtensions);
            if (this.m_bUseExtensions && block.m_aLines != null && block.m_aLines.getLineType(this.m_bUseExtensions) != ELineType.CODE) {
                block.m_sID = block.m_aLines.stripID();
            }
        }
        while (line != null && line.m_bIsEmpty) {
            line = line.m_aNext;
        }
        if (line == null) {
            return;
        }
        block12: while (line != null) {
            ELineType eLineType = line.getLineType(this.m_bUseExtensions);
            switch (eLineType) {
                case OTHER: {
                    Enum enum_;
                    boolean bl2 = line.m_bPrevEmpty;
                    while (line != null && !line.m_bIsEmpty) {
                        enum_ = line.getLineType(this.m_bUseExtensions);
                        if ((bl || this.m_bUseExtensions) && (enum_ == ELineType.OLIST || enum_ == ELineType.ULIST) || this.m_bUseExtensions && (enum_ == ELineType.CODE || enum_ == ELineType.FENCED_CODE || enum_ == ELineType.PLUGIN) || enum_ == ELineType.HEADLINE || enum_ == ELineType.HEADLINE1 || enum_ == ELineType.HEADLINE2 || enum_ == ELineType.HR || enum_ == ELineType.BQUOTE || enum_ == ELineType.XML || enum_ == ELineType.XML_COMMENT) break;
                        line = line.m_aNext;
                    }
                    if (line != null && !line.m_bIsEmpty) {
                        block.split((Line)line.m_aPrevious).m_eType = enum_ = bl && !bl2 ? EBlockType.NONE : EBlockType.PARAGRAPH;
                        block.removeLeadingEmptyLines();
                    } else {
                        enum_ = bl && (line == null || !line.m_bIsEmpty) && !bl2 ? EBlockType.NONE : EBlockType.PARAGRAPH;
                        block.split((Line)(line == null ? block.m_aLineTail : line)).m_eType = enum_;
                        block.removeLeadingEmptyLines();
                    }
                    line = block.m_aLines;
                    continue block12;
                }
                case CODE: {
                    while (line != null && (line.m_bIsEmpty || line.m_nLeading > 3)) {
                        line = line.m_aNext;
                    }
                    Block block2 = block.split(line != null ? line.m_aPrevious : block.m_aLineTail);
                    block2.m_eType = EBlockType.CODE;
                    block2.removeSurroundingEmptyLines();
                    continue block12;
                }
                case XML: 
                case XML_COMMENT: {
                    if (line.m_aPrevious != null) {
                        block.split(line.m_aPrevious);
                    }
                    block.split((Line)line.m_aXmlEndLine).m_eType = eLineType == ELineType.XML ? EBlockType.XML : EBlockType.XML_COMMENT;
                    block.removeLeadingEmptyLines();
                    line = block.m_aLines;
                    continue block12;
                }
                case BQUOTE: {
                    while (line != null && (line.m_bIsEmpty || !line.m_bPrevEmpty || line.m_nLeading != 0 || line.getLineType(this.m_bUseExtensions) == ELineType.BQUOTE)) {
                        line = line.m_aNext;
                    }
                    Block block2 = block.split(line != null ? line.m_aPrevious : block.m_aLineTail);
                    block2.m_eType = EBlockType.BLOCKQUOTE;
                    block2.removeSurroundingEmptyLines();
                    block2.removeBlockQuotePrefix();
                    this._recurse(block2, false);
                    line = block.m_aLines;
                    continue block12;
                }
                case HR: {
                    if (line.m_aPrevious != null) {
                        block.split(line.m_aPrevious);
                    }
                    block.split((Line)line).m_eType = EBlockType.RULER;
                    block.removeLeadingEmptyLines();
                    line = block.m_aLines;
                    continue block12;
                }
                case FENCED_CODE: {
                    line = line.m_aNext;
                    while (line != null && line.getLineType(this.m_bUseExtensions) != ELineType.FENCED_CODE) {
                        line = line.m_aNext;
                    }
                    if (line != null) {
                        line = line.m_aNext;
                    }
                    Block block2 = block.split(line != null ? line.m_aPrevious : block.m_aLineTail);
                    block2.m_eType = EBlockType.FENCED_CODE;
                    block2.m_sMeta = MarkdownHelper.getMetaFromFence(block2.m_aLines.m_sValue);
                    block2.m_aLines.setEmpty();
                    if (block2.m_aLineTail.getLineType(this.m_bUseExtensions) == ELineType.FENCED_CODE) {
                        block2.m_aLineTail.setEmpty();
                    }
                    block2.removeSurroundingEmptyLines();
                    continue block12;
                }
                case PLUGIN: {
                    line = line.m_aNext;
                    while (line != null && line.getLineType(this.m_bUseExtensions) != ELineType.PLUGIN) {
                        line = line.m_aNext;
                    }
                    if (line != null) {
                        line = line.m_aNext;
                    }
                    Block block2 = block.split(line != null ? line.m_aPrevious : block.m_aLineTail);
                    block2.m_eType = EBlockType.PLUGIN;
                    block2.m_sMeta = MarkdownHelper.getMetaFromFence(block2.m_aLines.m_sValue);
                    block2.m_aLines.setEmpty();
                    if (block2.m_aLineTail.getLineType(this.m_bUseExtensions) == ELineType.PLUGIN) {
                        block2.m_aLineTail.setEmpty();
                    }
                    block2.removeSurroundingEmptyLines();
                    continue block12;
                }
                case HEADLINE: 
                case HEADLINE1: 
                case HEADLINE2: {
                    if (line.m_aPrevious != null) {
                        block.split(line.m_aPrevious);
                    }
                    if (eLineType != ELineType.HEADLINE) {
                        line.m_aNext.setEmpty();
                    }
                    Block block2 = block.split(line);
                    block2.m_eType = EBlockType.HEADLINE;
                    if (eLineType != ELineType.HEADLINE) {
                        int n = block2.m_nHeadlineDepth = eLineType == ELineType.HEADLINE1 ? 1 : 2;
                    }
                    if (this.m_bUseExtensions) {
                        block2.m_sID = block2.m_aLines.stripID();
                    }
                    block2.transfromHeadline();
                    block.removeLeadingEmptyLines();
                    line = block.m_aLines;
                    continue block12;
                }
                case OLIST: 
                case ULIST: {
                    while (line != null) {
                        ELineType eLineType2 = line.getLineType(this.m_bUseExtensions);
                        if (!line.m_bIsEmpty && line.m_bPrevEmpty && line.m_nLeading == 0 && eLineType2 != ELineType.OLIST && eLineType2 != ELineType.ULIST) break;
                        line = line.m_aNext;
                    }
                    Block block3 = block.split(line != null ? line.m_aPrevious : block.m_aLineTail);
                    block3.m_eType = eLineType == ELineType.OLIST ? EBlockType.ORDERED_LIST : EBlockType.UNORDERED_LIST;
                    block3.m_aLines.m_bPrevEmpty = false;
                    block3.removeSurroundingEmptyLines();
                    block3.m_aLines.m_bPrevEmpty = false;
                    this._initListBlock(block3);
                    Block block2 = block3.m_aBlocks;
                    while (block2 != null) {
                        this._recurse(block2, true);
                        block2 = block2.m_aNext;
                    }
                    block3.expandListParagraphs();
                    continue block12;
                }
            }
            line = line.m_aNext;
        }
    }

    @Nonnull
    public MarkdownProcessingResult process(@Nonnull IReadableResource iReadableResource) throws IOException {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return this.process(iReadableResource.getReader(this.m_aConfig.getEncoding()));
    }

    @Nonnull
    public MarkdownProcessingResult process(@Nonnull InputStream inputStream) throws IOException {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        return this.process(StreamHelper.getBuffered((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)this.m_aConfig.getEncoding())));
    }

    @Nonnull
    public MarkdownProcessingResult process(@Nullable String string) throws IOException {
        return this.process((Reader)new NonBlockingStringReader(StringHelper.getNotNull((String)string)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MarkdownProcessingResult process(@Nonnull @WillClose Reader reader) throws IOException {
        try {
            Block block = this._readLines(reader);
            block.removeSurroundingEmptyLines();
            this._recurse(block, false);
            MarkdownHCStack markdownHCStack = new MarkdownHCStack();
            Block block2 = block.m_aBlocks;
            while (block2 != null) {
                this.m_aEmitter.emit(markdownHCStack, block2);
                block2 = block2.m_aNext;
            }
            MarkdownProcessingResult markdownProcessingResult = new MarkdownProcessingResult(markdownHCStack);
            return markdownProcessingResult;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }
}

